------------------------------------------------------------------------------
--                                 J N I                                    --
--                                                                          --
--                        Copyright (C) 2007, AdaCore                       --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
------------------------------------------------------------------------------

with JNI_Init_JVM;
with JNI;             use JNI;
with Booleans;        use Booleans;

procedure Test_Booleans is
begin
   declare
      Booleans      : constant Standard.Booleans.Booleans := New_Booleans;
      ATrueBoolean  : constant Boolean :=
                         Boolean (Booleans.Get_ATrueBoolean);
      AFalseBoolean : constant Boolean :=
                         Boolean (Booleans.Get_AFalseBoolean);
   begin
      if not ATrueBoolean = True then
         raise Program_Error
           with "ATrueBoolean is " & ATrueBoolean'Img;
      end if;
      if not AFalseBoolean = False then
         raise Program_Error
           with "AFalseBoolean is " & AFalseBoolean'Img;
      end if;
   end;

   declare
      Booleans_True  : constant Standard.Booleans.Booleans :=
                         New_Booleans (J_Boolean'(True));
      Booleans_False : constant Standard.Booleans.Booleans :=
                         New_Booleans (J_Boolean'(False));
      ABoolean       : Boolean;
   begin
      ABoolean := Boolean (Booleans_True.Get_ABoolean);
      if not ABoolean = True then
         raise Program_Error
           with "ABoolean is " & ABoolean'Img;
      end if;

      ABoolean := Boolean (Booleans_False.Get_ABoolean);
      if not ABoolean = False then
         raise Program_Error
           with "ABoolean is " & ABoolean'Img;
      end if;
   end;

   declare
      Booleans : constant Standard.Booleans.Booleans := New_Booleans;
      Bool     : Boolean;
   begin
      Bool := Boolean (Booleans.Complement (True));
      if not Bool = False then
         raise Program_Error
           with "Boolean is " & Bool'Img;
      end if;

      Bool := Boolean (Booleans.Complement (False));
      if not Bool = True then
         raise Program_Error
           with "Boolean is " & Bool'Img;
      end if;
   end;
end Test_Booleans;
