------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--     A S I S _ U L . S O U R C E _ T A B L E . P R O C E S S I N G .      --
--                           I N I T I A L I Z E                            --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2007-2010, AdaCore                      --
--                                                                          --
-- Asis Utility Library (ASIS UL) is free software; you can redistribute it --
-- and/or  modify  it  under  terms  of  the  GNU General Public License as --
-- published by the Free Software Foundation; either version 2, or (at your --
-- option)  any later version.  ASIS UL  is distributed in the hope that it --
-- will  be  useful,  but  WITHOUT  ANY  WARRANTY; without even the implied --
-- warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the --
-- GNU  General Public License for more details. You should have received a --
-- copy of the  GNU General Public License  distributed with GNAT; see file --
-- COPYING. If not, write to the Free Software Foundation, 59 Temple Place  --
--  - Suite 330, Boston,                                                    --
--                                                                          --
-- ASIS UL is maintained by ACT Europe (http://www.act-europe.fr).          --
--                                                                          --
------------------------------------------------------------------------------

--  This is a placeholder for the routine that implements a tool-specific
--  initialization for a tool that has a list of sources as a parameter. This
--  initialization should be performed after reading and processing of the
--  tool command-line parameters. Because this is tool-specific, this
--  placeholder does nothing.

with Ada2Java;                       use Ada2Java;
with Ada2Java.Simplifications;       use Ada2Java.Simplifications;
with Ada2Java.Bound_Elements.Common; use Ada2Java.Bound_Elements.Common;

separate (ASIS_UL.Source_Table.Processing)
procedure Initialize is
   Dummy_Type : Simple_Type_View_Access;
   Dummy_Ref  : Simple_Type_Reference;
   pragma Unreferenced (Dummy_Type, Dummy_Ref);
begin
   Trace ("Initialize table", Ada2Java.Debug);
   ASIS_UL.Options.Quiet_Mode := True;

   --  Prepare the environment and what needs to be set up
   Dummy_Type := Get_Exception_Occurence (The_Kernel);
   Dummy_Ref := Get_String (The_Kernel);
end Initialize;
