-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2011, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada2Java.Code_Wrappers;       use Ada2Java.Code_Wrappers;
with Ada2Java.Bound_Elements.Subprograms;
use Ada2Java.Bound_Elements.Subprograms;

package Ada2Java.Bound_Elements.Types is

   type Bound_Type is new Bound_Element_Record with private;

   overriding
   procedure Initialize
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Type);

   overriding
   procedure Bind
     (Element_Bound : access Bound_Type;
      Handle        : not null access Kernel.Kernel_Record);
   --  See inherited documentation

   function Get_View (This : Bound_Type) return Simple_Type_View_Access;

   type Modifier_Mode is (Setter, Getter);

   type Ada_Field_Modifiers_Handler is new Code_Wrapper with record
      Mode                   : Modifier_Mode;
      Var_Name               : Dynamic_Expression := Empty_Dynamic_Expression;
      This_Exp               : Dynamic_Expression := Empty_Dynamic_Expression;

      Object_View            : Simple_Object_View_Access;
      Is_Unrestricted_Access : Boolean := False;
      --  This field is true when the value of the field is carried trough
      --  an unrestricted access.
   end record;

   overriding
   procedure Wrap
     (Handler    : in out Ada_Field_Modifiers_Handler;
      Expression : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class);
   --  See inherited documentation

   type Ada_Component_Modifiers_Handler is new Code_Wrapper with record
      Mode      : Modifier_Mode;
      This_Exp  : Dynamic_Expression := New_Dynamic_Expression;
      Params_Nb : Integer := 0;

      Is_Unrestricted_Access : Boolean := False;
      --  This field is true when the value of the field is carried trough
      --  an unrestricted access.
   end record;

   overriding
   procedure Wrap
     (Handler           : in out Ada_Component_Modifiers_Handler;
      Expression        : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class);
   --  See inherited documentation

   type Null_Value_Handler is new Code_Wrapper with record
      null;
   end record;

   overriding
   procedure Wrap
     (Handler           : in out Null_Value_Handler;
      Expression        : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class);
   --  See inherited documentation

   type Boundary_Type is (First, Last, Length);

   type Ada_Bounds_Handler is new Code_Wrapper with record
      Type_Name    : Dynamic_Expression := Empty_Dynamic_Expression;
      Bound        : Boundary_Type;
      Bound_Number : Integer := 0;
   end record;

   overriding
   procedure Wrap
     (Handler    : in out Ada_Bounds_Handler;
      Expression : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class);
   --  See inherited documentation

   type Ada_Constructor_Handler is new Code_Wrapper with record
      Params_Nb    : Integer := 0;
      Type_Index   : Element_Index;
      Type_Name    : Wide_String_Access;
   end record;

   type Ada_Constructor_Handler_Access is access
     all Ada_Constructor_Handler'Class;

   overriding
   procedure Wrap
     (Handler    : in out Ada_Constructor_Handler;
      Expression : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class);
   --  See inherited documentation

   procedure Initialize_Constructor_View
     (Type_View            : Simple_Type_View_Access;
      Binded_Type_Name     : Wide_String_Access;
      Constructor_View     : out Simple_Subprogram_View_Access;
      Constructor_Map      : in out Wrapping_Map;
      Ada_Parameter_Hander : Ada_Constructor_Handler_Access := null);
   --  Initialize the subprogram view and the call handler in order to create
   --  a constructor. If Ada_Parameter_Handler is not null, then it will be
   --  installed in place of the default one for Ada parameters handling. It's
   --  supposed to derive from

   procedure Initialize_Constructor_Parameters
     (Constructor_View : Simple_Subprogram_View_Access);
   --  Initialize parameters of a constructor view, in particular in the case
   --  of disciminants.

   procedure Bind_Destructor
     (Handle   : not null access Kernel.Kernel_Record;
      Unit     : Bound_Unit;
      The_Type : Simple_Type_View_Access);
   --  Creates the destructor wrappers corresponding to the Conversion type.

   procedure Bind_Fields
     (Handle    : not null access Kernel.Kernel_Record;
      Type_View : Simple_Type_View_Access;
      Unit      : Bound_Unit);
   --  Create the fields accessors / modifiers associated with the Type_View
   --  parameter. Record discriminants are treated as constant fields for
   --  purposes of accessor generation.

   function Get_Constructor_Id
     (Element : Bound_Type) return Dynamic_Expression;
   --  Private and record have a handle on their constructor, trough the
   --  variable recorded here.

   procedure Bind_Equals
     (Handle    : not null access Kernel.Kernel_Record;
      Type_View : Simple_Type_View_Access;
      Unit      : Bound_Unit);
   --  Creates and bind the equals subprogram for the type given in parameter

   procedure Bind_Clone
     (Handle      : not null access Kernel.Kernel_Record;
      Type_View   : Simple_Type_View_Access;
      Unit        : Bound_Unit;
      Ada_Wrapper : Code_Wrapper_Access := null);
   --  Created and bind the internal clone function. If Ada_Wrapper is not
   --  null, then it will be used for the Ada Parameter_Resolver of the high
   --  subprogram in place of the default one installed by Bind_Clone. Limited
   --  types will be implemented by a final subprogram raising an exception.

   type Array_Manipulation_Kind is
     (Constrained_Object, Direct_Array_Access, Wrapped_Access);

   function Get_Array_Manipulation_Kind
     (Ref : Simple_Type_Reference) return Array_Manipulation_Kind;
   --  Return true if the reference is managed by a direct array access instead
   --  of an explicit {bounds, address} record.

private

   type Bound_Type is new Bound_Element_Record with record
      Type_View      : Simple_Type_View_Access;
      Constructor_Id : Dynamic_Expression;
   end record;

end Ada2Java.Bound_Elements.Types;
