-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2010, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada2Java.Code_Wrappers; use Ada2Java.Code_Wrappers;

package Ada2Java.Bound_Elements.Tagged_Types is

   function Create_Bound_Tagged_Type
     (Element : Simple_Element_View_Access) return Bound_Element;
   --  Return a new tagged bound element if the Element given in parameter fit
   --  into an extensible type.

   type Bound_Tagged_Type is new Bound_Element_Record with private;

   procedure Bind
     (Element_Bound : access Bound_Tagged_Type;
      Handle        : not null access Kernel.Kernel_Record);
   --  Generates the needed code in order to be able to use or extend the
   --  element given in parameter.

   type Tagged_Type_Ada_Dispatching_Wrapper is
     new Code_Wrapper with private;
   --  This wrapper has to be applied on ada internal subprogram  wrapping the
   --  primitives of an extensible type.

   overriding
   procedure Wrap
     (Wrapper    : in out Tagged_Type_Ada_Dispatching_Wrapper;
      Expression : Wrapping_Expression;
      Parameters : access Wrapper_Parameters'Class);
   --  See inherited documentation.

   function Get_Default_Implementation_Unit
     (Element_Bound : access Bound_Tagged_Type) return Bound_Unit;
   --  For abstract types, we need a default implementation bound class. It's
   --  recorded on this function.

private

   type Bound_Tagged_Type is new Bound_Element_Record with record
      Child_Wrapper_Type     : Dynamic_Expression;
      Default_Implementation : Bound_Unit := null;
      Discriminant_Renames   : Dynamic_Expression_Array_Access;
   end record;

   type Tagged_Type_Ada_Dispatching_Wrapper is new Code_Wrapper
   with record
      Ada_Dispatching_Param : Dynamic_Expression;
      Ada_Dispatching_Type  : Dynamic_Expression;
      Ada_Parent_Type       : Dynamic_Expression;

      Open_Upcast           : Dynamic_Expression;
      Close_Upcast          : Dynamic_Expression;
      Open_Instanciation    : Dynamic_Expression;
      Close_Instanciation   : Dynamic_Expression;

      Do_Upcast             : Boolean;
   end record;

end Ada2Java.Bound_Elements.Tagged_Types;
