-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2008-2009, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada.Characters.Conversions; use Ada.Characters.Conversions;

package body Ada2Java.Bound_Elements.Enums is

   procedure Initialize
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Enum) is
   begin
      Initialize
        (Handle, Element, Bound_Element_Record (Element_Bound.all)'Access);
      Element_Bound.Ref_Constructor_Id :=
        To_Dynamic_Expression (Get_Unique_Id);
   end Initialize;

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Element_Bound : access Bound_Enum;
      Handle        : not null access Kernel.Kernel_Record)
   is
      Unit : Bound_Unit;

      Type_Of : constant Simple_Type_View_Access :=
        Simple_Type_View_Access (Element_Bound.Simple_Element);
      Comma : Dynamic_Expression := Empty_Dynamic_Expression;
   begin
      Unit := Get_Or_Create_Bound_Unit (Handle, Element_Bound.Simple_Element);
      Unit.Java_File.Is_Enum := True;

      Append (Unit.Java_File.Open_Part, New_Line);

      if Ada2Java.Use_Java_1_5_Enums then
         Append (Unit.Java_File.Public_Body_Part, New_Line);

         for J in Type_Of.Enum_Values'Range loop
            Append
              (Unit.Java_File.Open_Part,
               Comma & New_Line & Type_Of.Enum_Values (J));

            if Comma = Empty_Dynamic_Expression then
               Comma := To_Dynamic_Expression (",");
            end if;
         end loop;

         Append (Unit.Java_File.Open_Part, ";");
      else
         Unit := Get_Or_Create_Bound_Unit
           (Handle, Element_Bound.Simple_Element);
         Append (Unit.Java_File.Public_Body_Part, New_Line);

         for J in Type_Of.Enum_Values'Range loop
            Append
              (Unit.Java_File.Public_Body_Part,
               New_Line
               & "public final static int "
               & Type_Of.Enum_Values (J) & " ="
               & To_Wide_String (Integer'Image (J - 1)) & ";");
         end loop;
      end if;

   end Bind;

end Ada2Java.Bound_Elements.Enums;
