//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                                  AJIS                                    //
//                                                                          //
//                     Copyright (C) 2007-2008, AdaCore                     //
//                                                                          //
// GNAT is free software;  you can  redistribute it  and/or modify it under //
// terms of the  GNU General Public License as published  by the Free Soft- //
// ware  Foundation;  either version 2,  or (at your option) any later ver- //
// sion.  GNAT is distributed in the hope that it will be useful, but WITH- //
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY //
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License //
// for  more details.  You should have  received  a copy of the GNU General //
// Public License  distributed with GNAT;  see file COPYING.  If not, write //
// to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, //
// Boston, MA 02110-1301, USA.                                              //
//                                                                          //
// As a special exception,  if other files  instantiate  generics from this //
// unit, or you link  this unit with other files  to produce an executable, //
// this  unit  does not  by itself cause  the resulting  executable  to  be //
// covered  by the  GNU  General  Public  License.  This exception does not //
// however invalidate  any other reasons why  the executable file  might be //
// covered by the  GNU Public License.                                      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis.internal.ada;

import com.adacore.ajis.IProxy;
import com.adacore.ajis.IProxyRef;
import com.adacore.ajis.NativeException;

public abstract class AdaProxy implements IProxy {

	/**
	 * When this is not null, this points to the proxy object containing this
	 * proxy, so that it's not garbage-collected until this object is subject
	 * to garbage collection as well.
	 */
	public IProxy container;
	
	public Owner myOwner = Owner.NATIVE;
	
	public Allocator myAllocator = Allocator.UNKNOWN;
	
	protected int [] adaAccess;
	
	public int [] getAccess () {
		return adaAccess;
	}
		
	public IProxyRef NewProxyRef () {
		return null;
	}
	
	public AdaProxy (){

	}

	public AdaProxy (AdaAccess access) {
		if (access != null) this.adaAccess = access.fAcc;
	}
	
	public Object clone () throws CloneNotSupportedException {
		AdaProxy cloned = (AdaProxy) super.clone ();
		
		cloned.adaAccess = internalClone ();
		cloned.proxyCloned(this);
		
		return cloned;
	}

	public void setOwner (Owner theOwner) {
		if (getOwner() == theOwner) {
			//  Nothing has to change
		} else if (getAllocator() == Allocator.DYNAMIC) {
			myOwner = theOwner;
		} else {
			throw new NativeException(
					"Only objects allocated dynamically can change owner.");
		}
	}

	public Owner getOwner () {
		return myOwner;
	}
	
	public Allocator getAllocator () {
		return myAllocator;
	}

	public void proxyCloned (IProxy initialObject) {
	
	}
	
	protected void finalize () {
		if (myOwner == Owner.PROXY 
				&& adaAccess != null 
				&& myAllocator == Allocator.DYNAMIC) {
			deallocateNativeObject();
		}
	}

	@SuppressWarnings("unused")
	private void setAddress (int [] address) {
		this.adaAccess = address;
	}
	
	@SuppressWarnings("unused")
	private AdaProxy cloneNoCopy () throws CloneNotSupportedException {
		AdaProxy cloned = (AdaProxy) super.clone ();
		
		return cloned;
	}
	
	public boolean isEscapable () {
		return myOwner == Owner.NATIVE 
		&& myAllocator == Allocator.DYNAMIC;
	}
	
	protected abstract int [] internalClone ();
}
