------------------------------------------------------------------------------
--                                                                          --
--                   GNAT RUN-TIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                   S Y S T E M . O S _ I N T E R F A C E                  --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--             Copyright (C) 1991-1994, Florida State University            --
--             Copyright (C) 1995-2009, Free Software Foundation, Inc.      --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- The GNAT Ada tool chain for the JVM and .NET platforms is  maintained by --
-- AdaCore - http://www.adacore.com                                         --
--                                                                          --
------------------------------------------------------------------------------

--  This is a Java version of this package

--  This package includes all direct interfaces to OS services
--  that are needed by children of System.

--  PLEASE DO NOT add any with-clauses to this package. It is designed to be
--  a bottom-level (leaf) package.

with Interfaces.CIL.Object;
with Interfaces.CIL.Threading.Thread;

package System.OS_Interface is
   pragma Preelaborate;

   subtype Native_Int is System.Address;

   type Thread    is new Interfaces.CIL.Threading.Thread.Typ with null record;
   type Thread_Id is access all Thread;

   function Get_Thread
     (This : access Thread) return Interfaces.CIL.Threading.Thread.Ref;

   type Wrapper_Proc is access procedure (Obj : Interfaces.CIL.Object.Ref);
   pragma Import
     (CIL, Wrapper_Proc, "mgnat.adalib.TaskWrapper");

   --  Note: System.Address is used below instead of Task_Id to avoid a
   --  circular dependency. The GNULLI is responsible for converting from and
   --  to a Task_Id this value.

   function new_Thread (This    : Thread_Id := null;
                        Self_Id : System.Address;
                        Wrapper : Wrapper_Proc) return Thread_Id;
   --  Create a new thread

   function Get_Self_Id return System.Address;
   --  Return the self id associated with the current thread.

private
   pragma Convention (CIL, Thread);
   pragma Cil_Constructor (new_Thread);
   pragma Import (CIL, Get_Thread, "Get_Thread");
   pragma Import (CIL, Get_Self_Id, "getSelfId");
end System.OS_Interface;

pragma Import (CIL, System.OS_Interface, "mgnat.adalib.ada_wrapper");
