------------------------------------------------------------------------------
--                                   JNI                                    --
--                                                                          --
--                     Copyright (C) 2005-2007, AdaCore                     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
------------------------------------------------------------------------------

with JNI_Init_JVM;
with Ada.Text_IO;
with Counter;
with Java_Primitives;

procedure Simple is
   Counter1 : Counter.Counter := Counter.New_Counter;
   Counter2 : Counter.Counter := Counter.New_Counter (10);
   I        : Java_Primitives.Int;
begin
   Counter1.Increment;
   I := Counter1.GetValue;
   Ada.Text_IO.Put_Line ("From Ada: " & Java_Primitives.Int'Image (I));
   Counter1.PrintValue;

   Counter2.Decrement;
   I := Counter2.GetValue;
   Ada.Text_IO.Put_Line ("From Ada: " & Java_Primitives.Int'Image (I));
   Counter2.PrintValue;
end Simple;
