-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2009, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada.Characters.Conversions; use Ada.Characters.Conversions;
with Ada.Wide_Text_IO;           use Ada.Wide_Text_IO;
with Ada.Strings;       use Ada.Strings;
use Ada.Characters;

package body Ada2Java is

   ----------
   -- Dump --
   ----------

   function Dump (Loc : Source_Location) return Wide_String is
   begin
      if Loc /= null then
         return Loc.all;
      else
         return "[no location]";
      end if;
   end Dump;

   -------------------
   -- Push_Location --
   -------------------

   function Push_Location (Loc : Source_Location) return Location_Handle is
   begin
      if Loc /= null then
         Current_Location := Current_Location + 1;
         Location_Stack (Current_Location) := Loc;
         return Current_Location;
      else
         return 0;
      end if;
   end Push_Location;

   procedure Pop_Location (Up_To : Location_Handle) is
   begin
      if Up_To /= 0 then
         Current_Location := Up_To - 1;
      end if;
   end Pop_Location;

   function Dump_Current_Location return Wide_String is
   begin
      return Dump (Location_Stack (Current_Location));
   end Dump_Current_Location;

   -------------------------
   -- Trace_With_Location --
   -------------------------

   procedure Trace_With_Location
     (Text  : Wide_String;
      Level : Trace_Level;
      Loc   : Source_Location := Null_Location)
   is
   begin
      if Level <= Current_Trace_Level then
         if Loc = Null_Location then
            Put (Dump_Current_Location & ": ");
         else
            Put (Dump (Loc) & ": ");
         end if;

         case Level is
            when Errors_Only =>
               null;
            when Errors_And_Warnings =>
               Put ("warning: ");
            when Full_Verbosity | Limited_Verbosity =>
               Put ("info: ");
            when Debug =>
               Put ("debug: ");
            when others =>
               null;
         end case;

         Put_Line (Text);
         Flush;
      end if;
   end Trace_With_Location;

   -----------
   -- Trace --
   -----------

   procedure Trace (Text : Wide_String; Level : Trace_Level) is
   begin
      if Level <= Current_Trace_Level then
         case Level is
            when Errors_Only =>
               Put ("[error  ] ");
            when Errors_And_Warnings =>
               Put ("[warning] ");
            when Full_Verbosity | Limited_Verbosity =>
               Put ("[info   ] ");
            when Debug =>
               Put ("[debug  ] ");
            when others =>
               null;
         end case;

         Put_Line (Text);
         Flush;
      end if;
   end Trace;

end Ada2Java;
