-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                     Copyright (C) 2008, AdaCore                   --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

--  This package provides access to common simple elements.

package Ada2Java.Bound_Elements.Common is

   function Get_Exception_Occurence
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Simple_Type_View_Access;
   --  Returns a handle on the predefined Ada.Exception.Exception_Occurence
   --  type.

   function Get_String
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Simple_Type_Reference;
   --  Returns a handle on the predefined Standard.String type.

   function Get_Boolean
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Simple_Type_View_Access;
   --  Returns a handle on the predefined Standard.Boolean type.

   function Get_Standard_Package
     (Handle : not null access Ada2Java.Kernel.Kernel_Record)
      return Ada2Java.Packages.Package_Handle;
   --  Returns a handle on the predefined Standard package.

end Ada2Java.Bound_Elements.Common;
