//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                                  AJIS                                    //
//                                                                          //
//                     Copyright (C) 2007-2008, AdaCore                     //
//                                                                          //
// GNAT is free software;  you can  redistribute it  and/or modify it under //
// terms of the  GNU General Public License as published  by the Free Soft- //
// ware  Foundation;  either version 2,  or (at your option) any later ver- //
// sion.  GNAT is distributed in the hope that it will be useful, but WITH- //
// OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY //
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License //
// for  more details.  You should have  received  a copy of the GNU General //
// Public License  distributed with GNAT;  see file COPYING.  If not, write //
// to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, //
// Boston, MA 02110-1301, USA.                                              //
//                                                                          //
// As a special exception,  if other files  instantiate  generics from this //
// unit, or you link  this unit with other files  to produce an executable, //
// this  unit  does not  by itself cause  the resulting  executable  to  be //
// covered  by the  GNU  General  Public  License.  This exception does not //
// however invalidate  any other reasons why  the executable file  might be //
// covered by the  GNU Public License.                                      //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

package com.adacore.ajis.internal.ada;

import com.adacore.ajis.IEscapable;
import com.adacore.ajis.IProxy;
import com.adacore.ajis.NativeException;
import com.adacore.ajis.IProxy.Allocator;
import com.adacore.ajis.IProxy.Owner;

public final class Utils {

	public static void checkEscapable (IEscapable escapable, String objectName) {
		if (!escapable.isEscapable()) {
			if (escapable instanceof IProxy) {
				IProxy proxy = (IProxy) escapable;
				
				if (proxy.getOwner() == Owner.PROXY) {
					throw new NativeException("Value of " + objectName
							+ " cannot be escaped, "
							+ "because it's owned by the proxy. See pragma "
							+ "annotation \"Assume_Escaped\" for more details.");
				} else if (proxy.getAllocator() != Allocator.DYNAMIC) {
					throw new NativeException("Value of " + objectName
							+ " cannot be escaped, "
							+ "because its allocator is not dynamic. See pragma "
							+ "annotation \"Assume_Escaped\" for more details.");
				}
			} else {
				throw new NativeException("Value of " + objectName
						+ " cannot be escaped, see pragma "
						+ "annotation \"Assume_Escaped\" for more details.");
			}
		}
	}
	
}
