with Interfaces.Java.JNI; use Interfaces.Java.JNI;
with AJIS.Internal.Java;
with %library_package%;
with Ada.Text_IO;
with Ada.Command_Line;
with Interfaces.C.Strings;

procedure %main_name% is
   VM : aliased Java_VM_Access;
   Env : aliased JNI_Env_Access;
   VM_Args : Java_VM_Init_Args;
   Result : J_Int;
   Init_Method_Params : J_Value_Array (1 .. 1);
   Args_Param         : J_Object_J_Array;
   Init_Method : AJIS.Internal.Java.Java_Method_Access :=
     AJIS.Internal.Java.Get_Java_Method
       ("%main_java_class%", "main", "([Ljava/lang/String;)V", True);
begin
   AJIS.Internal.Java.Initialize_JVM_Parameters (VM_Args);

   Result := Interfaces.Java.JNI.JNI_Create_Java_VM
     (VM'Access, Env'Access, VM_Args);

   if Result /= 0 then
      Ada.Text_IO.Put_Line
        (Ada.Text_IO.Standard_Error,
         "Creation of the Java Virtual Machine failed");

      return;
   end if;

   %library_package%.Register_All_Natives (Env);

   Args_Param := New_Object_Array
     (Env,
      J_Size (Ada.Command_Line.Argument_Count),
      Find_Class (Env, String'("Ljava/lang/String;")),
      J_Null_Object);

   for J in 1 .. Ada.Command_Line.Argument_Count loop
      declare
         UTF : Interfaces.C.Strings.chars_ptr :=
           Interfaces.C.Strings.New_String (Ada.Command_Line.Argument (J));
         Arg : J_String := New_String_UTF (Env, UTF);
      begin
         Set_Object_Array_Element (Env, Args_Param, J_Size (J - 1), Arg);

         --  What are we supposed to free here ???
         --  Release_String_UTF_Chars (Env, Arg, UTF);
         Interfaces.C.Strings.Free (UTF);
      end;
   end loop;

   %library_package%.Initialize_Library (Env);

   AJIS.Internal.Java.Initialize (Init_Method, Env);

   Init_Method_Params (1) := (Jobject, Args_Param);

   Call_Static_Void_Method_A
     (Env,
      AJIS.Internal.Java.Get_Class (Init_Method),
      AJIS.Internal.Java.Get_Id (Init_Method),
      Init_Method_Params);
end %main_name%;
