-----------------------------------------------------------------------
--                             Ada2Java                              --
--                                                                   --
--                  Copyright (C) 2007-2009, AdaCore                 --
--                                                                   --
-- Ada2Java is free software;  you can redistribute it and/or modify --
-- it under the terms of the GNU General Public License as published --
-- by the Free Software Foundation; either version 2 of the License, --
-- or (at your option) any later version.                            --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

package Ada2Java.Bound_Elements.Callbacks is

   function Create_Bound_Callback
     (Element : Simple_Element_View_Access) return Bound_Element;

   type Bound_Callback is new Bound_Element_Record with private;

   overriding
   procedure Initialize
     (Handle        : not null access Kernel.Kernel_Record;
      Element       : Simple_Element_View_Access;
      Element_Bound : access Bound_Callback);

   overriding
   procedure Bind
     (Element_Bound : access Bound_Callback;
      Handle        : not null access Kernel.Kernel_Record);
   --  See default implementation

   function Get_Default_Implementation_Unit_Name
     (Element_Bound : access Bound_Callback) return Dynamic_Expression;
   --  Return the unit holding the default implementation of this callback,
   --  able to call an Ada-implemented procedure.

   function Get_Ada_High_Name
     (Element_Bound : access Bound_Callback) return Dynamic_Expression;
   --  Return the name of the high Ada name of this callback.

private

   type Bound_Callback is new Bound_Element_Record with record
      Child_Wrapper_Type          : Wide_String_Access;
      Default_Implementation_Name : Dynamic_Expression;
   end record;

end Ada2Java.Bound_Elements.Callbacks;
