------------------------------------------------------------------------------
--                                                                          --
--                            GLADE COMPONENTS                              --
--                                                                          --
--       S Y S T E M . G A R L I C . S T O R A G E _ H A N D L I N G        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 1996-2006 Free Software Foundation, Inc.           --
--                                                                          --
-- GARLIC is free software;  you can redistribute it and/or modify it under --
-- terms of the  GNU General Public License  as published by the Free Soft- --
-- ware Foundation;  either version 2,  or (at your option)  any later ver- --
-- sion.  GARLIC is distributed  in the hope that  it will be  useful,  but --
-- WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTABI- --
-- LITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public  --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License  distributed with GARLIC;  see file COPYING.  If  --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--
--
--
--
--
--
--
--               GLADE  is maintained by ACT Europe.                        --
--               (email: glade-report@act-europe.fr)                        --
--                                                                          --
------------------------------------------------------------------------------

with System.Garlic.Soft_Links;
with System.Storage_Elements;
with System.Storage_Pools;

generic
   Max_Objects        : Positive;
   Static_Object_Size : System.Storage_Elements.Storage_Count;
package System.Garlic.Storage_Handling is

   --  This package needs comments ???

   type Garlic_Storage_Pool is
     new System.Storage_Pools.Root_Storage_Pool with private;

   procedure Initialize (Pool : in out Garlic_Storage_Pool);
   procedure Finalize   (Pool : in out Garlic_Storage_Pool);

   procedure Allocate
     (Pool                     : in out Garlic_Storage_Pool;
      Storage_Address          : out Address;
      Size_In_Storage_Elements : System.Storage_Elements.Storage_Count;
      Alignment                : System.Storage_Elements.Storage_Count);

   procedure Deallocate
     (Pool                     : in out Garlic_Storage_Pool;
      Storage_Address          : Address;
      Size_In_Storage_Elements : System.Storage_Elements.Storage_Count;
      Alignment                : System.Storage_Elements.Storage_Count);

   function Storage_Size (Pool : Garlic_Storage_Pool)
      return System.Storage_Elements.Storage_Count;

   procedure Initialize;

private

   type Array_Of_Addresses is array (1 .. Max_Objects) of Address;
   type Array_Of_Boolean   is array (1 .. Max_Objects) of Boolean;

   type Garlic_Storage_Pool is
     new System.Storage_Pools.Root_Storage_Pool with record
        N_Objects : Natural;
        pragma Atomic (N_Objects);
        Addresses : Array_Of_Addresses;
        Used      : Array_Of_Boolean;
        Mutex     : Soft_Links.Mutex_Access;
        Ready     : Boolean;
     end record;

   --  Ready denotes that Mutex has been created.

end System.Garlic.Storage_Handling;
