------------------------------------------------------------------------------
--                                  wPOSIX                                  --
--                                                                          --
--                     Copyright (C) 2008-2010, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

package body POSIX.Permissions is

   Dummy_Process_Permission_Set : Permission_Set := Owner_Permission_Set;

   -------------------------------------
   -- Get_Allowed_Process_Permissions --
   -------------------------------------

   function Get_Allowed_Process_Permissions return Permission_Set is
   begin
      return Dummy_Process_Permission_Set;
   end Get_Allowed_Process_Permissions;

   -------------------------------------
   -- Set_Allowed_Process_Permissions --
   -------------------------------------

   procedure Set_Allowed_Process_Permissions
     (Permissions : Permission_Set) is
   begin
      Dummy_Process_Permission_Set := Permissions;
   end Set_Allowed_Process_Permissions;

   -------------------------------------
   -- Set_Allowed_Process_Permissions --
   -------------------------------------

   procedure Set_Allowed_Process_Permissions
     (Permissions :        Permission_Set;
      Old_Perms   :    out Permission_Set) is
   begin
      Old_Perms := Dummy_Process_Permission_Set;
      Dummy_Process_Permission_Set := Permissions;
   end Set_Allowed_Process_Permissions;

end POSIX.Permissions;
