/****************************************************************************
 *                                                                          *
 *                         GNAT COMPILER COMPONENTS                         *
 *                                                                          *
 *                          V X _ C R T B E G I N                           *
 *                                                                          *
 *                          C Implementation File                           *
 *                                                                          *
 *              Copyright (C) 2016, Free Software Foundation, Inc.          *
 *                                                                          *
 * GNAT is free software;  you can  redistribute it  and/or modify it under *
 * terms of the  GNU General Public License as published  by the Free Soft- *
 * ware  Foundation;  either version 3,  or (at your option) any later ver- *
 * sion.  GNAT is distributed in the hope that it will be useful, but WITH- *
 * OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.                                     *
 *                                                                          *
 * As a special exception under Section 7 of GPL version 3, you are granted *
 * additional permissions described in the GCC Runtime Library Exception,   *
 * version 3.1, as published by the Free Software Foundation.               *
 *                                                                          *
 * You should have received a copy of the GNU General Public License and    *
 * a copy of the GCC Runtime Library Exception along with this program;     *
 * see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    *
 * <http://www.gnu.org/licenses/>.                                          *
 *                                                                          *
 * GNAT was originally developed  by the GNAT team at  New York University. *
 * Extensive contributions were provided by Ada Core Technologies Inc.      *
 *                                                                          *
 ****************************************************************************/

/* Common body for the various flavors of vx_crtbegin C sources we need
   to perform eh frame registration/deregistration in various
   circumstances.  #includers should define CDTOR_VISIBILITY. */

#include "tconfig.h"
#include "tsystem.h"
#include "coretypes.h"
#include "tm.h"
#include "unwind-dw2-fde.h"

/* Pick names that the VxWorks muncher will get if involved.  */

#ifdef __RTP__
/* 101 is the highest user level priority allowed by VxWorks.  */
#define CTOR_NAME _STI__101____crtbe_register_frame
#define DTOR_NAME _STI__101____crtbe_deregister_frame
#define CTOR_ATTRIBUTE __attribute__((constructor(101)))
#define DTOR_ATTRIBUTE __attribute__((destructor(101)))
#else
#define CTOR_NAME _GLOBAL__I___crtbe_register_frame
#define DTOR_NAME _GLOBAL__D___crtbe_deregister_frame
#define CTOR_ATTRIBUTE __attribute__((unused))
#define DTOR_ATTRIBUTE __attribute__((unused))
#endif

CDTOR_VISIBILITY void CTOR_NAME (void) CTOR_ATTRIBUTE;
CDTOR_VISIBILITY void DTOR_NAME (void) DTOR_ATTRIBUTE;

static char __EH_FRAME_BEGIN__[]
__attribute__((section(EH_FRAME_SECTION_NAME), aligned(4)))
  = { };

CDTOR_VISIBILITY void CTOR_NAME (void)
{
  static struct object object;
  __register_frame_info (__EH_FRAME_BEGIN__, &object);
}

CDTOR_VISIBILITY void DTOR_NAME (void)
{
  __deregister_frame_info (__EH_FRAME_BEGIN__);
}

