------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUN-TIME COMPONENTS                         --
--                                                                          --
--                       S Y S T E M .  I O P O R T S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2010-2013, AdaCore                      --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.                                     --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces; use Interfaces;

package body System.IOPorts is

   function Get_Port_Address (P : Port_Id) return Address;
   pragma Inline (Get_Port_Address);
   --  Get the address corresponding to a port id

   ----------------------
   -- Get_Port_Address --
   ----------------------

   function Get_Port_Address (P : Port_Id) return Address is
   begin
      return 16#8000_0000# + Port_Id'Pos (P);
   end Get_Port_Address;

   ---------
   -- Inb --
   ---------

   function Inb (P : Port_Id) return Interfaces.Unsigned_8 is
      Port_Byte : Unsigned_8;
      pragma Atomic (Port_Byte);
      for Port_Byte'Address use Get_Port_Address (P);
   begin
      return Port_Byte;
   end Inb;

   ----------
   -- Outb --
   ----------

   procedure Outb (P : Port_Id; B : Unsigned_8) is
      Port_Byte : Unsigned_8;
      pragma Volatile (Port_Byte);
      for Port_Byte'Address use Get_Port_Address (P);
   begin
      Port_Byte := B;
   end Outb;

end System.IOPorts;
