------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2013, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; use Ada.Text_IO;
with Flash; use Flash;
with Ada.Unchecked_Conversion;
with System;
with Interfaces;
with Mpc55xx;
with Netloader;
with Loader;
pragma Unreferenced (Mpc55xx);
pragma Unreferenced (Netloader);
pragma Unreferenced (Loader);

package body Config is
   function To_Unsigned_32 is new Ada.Unchecked_Conversion
     (System.Address, Interfaces.Unsigned_32);

   procedure Disp_Start is
   begin
      Put ("Running from ");
      if In_Flash (To_Unsigned_32 (Disp_Start'Address)) then
         Put ("ROM");
      else
         Put ("RAM");
      end if;
      New_Line;
   end Disp_Start;

end Config;
