------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2013, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Netutils; use Netutils;

package Netcfg is
   My_Eth_Addr : Eth_Addr := (16#aa#, 16#00#, 16#00#,
                              16#00#, 16#00#, 16#01#);
   --  My ethernet address. Either set by Eth_Init or used by Eth_Init if the
   --  board has no ethernet address.

   My_Ip_Addr : In_Addr := To_In_Addr ((10, 10, 1, 43));
   My_Netmask : In_Addr := To_In_Addr ((255, 255, 255, 0));
   --  Board IP address and netmask

   Gw_Ip_Addr : In_Addr := Null_Ip_Addr;
   --  IP address of the gateway

   Srv_Ip_Addr : In_Addr := Null_Ip_Addr;
   --  IP address of the server

   Srv_Eth_Addr : Eth_Addr := Null_Eth_Addr;
end Netcfg;
