------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2018, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Interrupts;       use Ada.Interrupts;
with Ada.Interrupts.Names;
with System;

package IRQ is

   procedure Trigger_Interrupt;
   --  Trigger an interrupt by writing to the SoftInt register

   procedure Clear_Interrupt;
   --  Clear an interrupt by writing to the SoftIntClear register

   IRQ_Name : constant Interrupt_ID := Names.IRQ_5;

   protected IRQ_Handler is
      pragma Interrupt_Priority (System.Interrupt_Priority'Last);
   private
      procedure Handler;
      pragma Attach_Handler (Handler, IRQ_Name);
   end IRQ_Handler;
end IRQ;
