------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2018, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;

with Interfaces.M1AGL.CoreInterrupt; use Interfaces.M1AGL.CoreInterrupt;

package body IRQ is

   -----------------------
   -- Trigger_Interrupt --
   -----------------------

   procedure Trigger_Interrupt is
   begin
      CoreInterrupt_Periph.IRQ_Soft_Interrupt.IRQ.Arr
        (Integer (IRQ_Name)) := True;
   end Trigger_Interrupt;

   ---------------------
   -- Clear_Interrupt --
   ---------------------

   procedure Clear_Interrupt is
   begin
      CoreInterrupt_Periph.IRQ_Soft_Interrupt_Clear.IRQ.Arr
        (Integer (IRQ_Name)) := True;
   end Clear_Interrupt;

   -----------------
   -- IRQ_Handler --
   -----------------

   protected body IRQ_Handler is

      -------------
      -- Handler --
      -------------

      procedure Handler is
      begin
         Ada.Text_IO.Put_Line ("Inside Interrupt Handler");
         Clear_Interrupt;
      end Handler;
   end IRQ_Handler;
end IRQ;
