------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2013, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces; use Interfaces;

package Ppc is
   generic
      Spr : Natural;
   function Get_Spr return Unsigned_32;

   generic
      Spr : Natural;
   procedure Set_Spr (V : Unsigned_32);

   function Get_Msr return Unsigned_32;
   function Get_Tbu return Unsigned_32;
   function Get_Tbl return Unsigned_32;

   --  MSR bits
   MSR_IR : constant := 2#10_0000#;
   MSR_DR : constant := 2#01_0000#;
   MSR_EE : constant := 2#1000_0000_0000_0000#;
   MSR_PR : constant := 2#0100_0000_0000_0000#;
end Ppc;
