------------------------------------------------------------------------------
--                                                                          --
--                       Copyright (C) 2010, AdaCore                        --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

package Gdbstub_Io is
   --  Very simple interface to character oriented channel (uart, socket...)

   procedure Initialize;
   --  Initialize this IO subsystem.

   function Read_Byte return Character;
   --  Wait for the next byte.  This is blocking.
   --  There is currently no error handling.

   procedure Write_Byte (C : Character);
   --  Write a byte.

   procedure Write_Debug (C : Character);
   --  Optionnal output-only debug port.

   procedure Kill;
   --  Kill the target, ie reboot.
end Gdbstub_Io;
