------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2013, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces; use Interfaces;
with Commands; use Commands;
with Console; use Console;
with Term; use Term;
with Memwrite;
with System;
with Dumps;

package body Loader is
   procedure Proc_Go is
      procedure Called;
      pragma Import (Ada, Called);
      for Called'Address use System'To_Address (Memwrite.Exec_Addr);
      Ok : Boolean;
   begin
      Next_Word;
      if Pos <= Line_Len then
         if Pos = End_Pos and then Line (Pos) = '?' then
            Put ("Start at ");
            Put_Line (Dumps.Image8 (Memwrite.Exec_Addr));
            return;
         else
            Parse_Unsigned32 (Memwrite.Exec_Addr, Ok);
            if not Ok then
               return;
            end if;
         end if;
      else
         if Memwrite.Exec_Addr = Memwrite.Invalid_Exec_Addr then
            Put_Line ("No entry point. Try load");
            return;
         end if;
      end if;
      Called;
   end Proc_Go;

   Commands : aliased Command_List :=
     (1,
       (1 => (new String'("go - Execute loaded file"),
              Proc_Go'Access)),
      null);
begin
   Register_Commands (Commands'Access);
end Loader;
