------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2013, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

--  This package provide a memory writing service (to be used by loaders). It
--  handles write by packets (for some FLASH) and cache synchronization.

with Interfaces; use Interfaces;
with System.Storage_Elements; use System.Storage_Elements;

package Memwrite is
   procedure Init;
   --  Initialize the service. Can be called several times

   procedure Flush;
   --  To be called once the loading is finished. Will flush cached content
   --  if any.

   procedure Write (Addr : Unsigned_32; Content : Storage_Array);
   --  Write Content at Addr

   Invalid_Exec_Addr : constant := 1;
   Exec_Addr : Unsigned_32 := Invalid_Exec_Addr;
   --  Entry point (set by the loader)

end Memwrite;
