------------------------------------------------------------------------------
--                                                                          --
--                               GNAT EXAMPLE                               --
--                                                                          --
--                        Copyright (C) 2013, AdaCore                       --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces; use Interfaces;

package Oled is
   type Byte_Array is array (Natural range <>) of Unsigned_8;

   procedure Oled_Cmd (Bytes : Byte_Array);
   procedure Oled_Data (Bytes : Byte_Array);
   --  Low level commands

   procedure Oled_Init;
   --  Initialize the module. Must be called before any other commands.

   procedure Oled_Clear;
   --  Clear the screen

   subtype Col_Type is Natural range 0 .. 63;
   subtype Line_Type is Natural range 0 .. 95;

   type Image_Type is array (Unsigned_8 range <>, Unsigned_8 range <>) of
     Unsigned_8;
   --  An image is an array of dixel. A dixel is a pair of point.
   --  First dimension is vertical, second is horizontal.

   procedure Draw_Image (X : Col_Type; Y : Line_Type; Image : Image_Type);
   --  Draw an image on the screen.
end Oled;
