------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2000-2009, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

with AWS.Config.Utils;
with AWS.Utils;

package body AWS.Config.Set is

   -----------------------
   -- Accept_Queue_Size --
   -----------------------

   procedure Accept_Queue_Size (O : in out Object; Value : Positive) is
   begin
      O.P (Accept_Queue_Size).Pos_Value := Value;
   end Accept_Queue_Size;

   ---------------
   -- Admin_URI --
   ---------------

   procedure Admin_URI (O : in out Object; Value : String) is
   begin
      O.P (Admin_URI).Str_Value := To_Unbounded_String (Value);
   end Admin_URI;

   -------------------------------
   -- Case_Sensitive_Parameters --
   -------------------------------

   procedure Case_Sensitive_Parameters
     (O     : in out Object;
      Value : Boolean) is
   begin
      O.P (Case_Sensitive_Parameters).Bool_Value := Value;
   end Case_Sensitive_Parameters;

   -----------------
   -- Certificate --
   -----------------

   procedure Certificate (O : in out Object; Filename : String) is
   begin
      O.P (Certificate).Str_Value := To_Unbounded_String (Filename);
   end Certificate;

   ------------------------
   -- Check_URL_Validity --
   ------------------------

   procedure Check_URL_Validity (O : in out Object; Value : Boolean) is
   begin
      O.P (Check_URL_Validity).Bool_Value := Value;
   end Check_URL_Validity;

   ---------------------------------
   -- Cleaner_Client_Data_Timeout --
   ---------------------------------

   procedure Cleaner_Client_Data_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Cleaner_Client_Data_Timeout).Dur_Value := Value;
   end Cleaner_Client_Data_Timeout;

   -----------------------------------
   -- Cleaner_Client_Header_Timeout --
   -----------------------------------

   procedure Cleaner_Client_Header_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Cleaner_Client_Header_Timeout).Dur_Value := Value;
   end Cleaner_Client_Header_Timeout;

   -------------------------------------
   -- Cleaner_Server_Response_Timeout --
   -------------------------------------

   procedure Cleaner_Server_Response_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Cleaner_Server_Response_Timeout).Dur_Value := Value;
   end Cleaner_Server_Response_Timeout;

   -------------------------------------
   -- Cleaner_Wait_For_Client_Timeout --
   -------------------------------------

   procedure Cleaner_Wait_For_Client_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Cleaner_Wait_For_Client_Timeout).Dur_Value := Value;
   end Cleaner_Wait_For_Client_Timeout;

   ----------------------------
   -- Directory_Browser_Page --
   ----------------------------

   procedure Directory_Browser_Page (O : in out Object; Value : String) is
   begin
      O.P (Directory_Browser_Page).Str_Value := To_Unbounded_String (Value);
   end Directory_Browser_Page;

   ----------------
   -- Down_Image --
   ----------------

   procedure Down_Image (O : in out Object; Value : String) is
   begin
      O.P (Down_Image).Str_Value := To_Unbounded_String (Value);
   end Down_Image;

   -------------------------------
   -- Error_Log_Filename_Prefix --
   -------------------------------

   procedure Error_Log_Filename_Prefix
     (O : in out Object; Value : String) is
   begin
      O.P (Error_Log_Filename_Prefix).Str_Value := To_Unbounded_String (Value);
   end Error_Log_Filename_Prefix;

   --------------------------
   -- Error_Log_Split_Mode --
   --------------------------

   procedure Error_Log_Split_Mode (O : in out Object; Value : String) is
   begin
      O.P (Error_Log_Split_Mode).Str_Value := To_Unbounded_String (Value);
   end Error_Log_Split_Mode;

   --------------------------
   -- Exchange_Certificate --
   --------------------------

   procedure Exchange_Certificate (O : in out Object; Value : Boolean) is
   begin
      O.P (Exchange_Certificate).Bool_Value := Value;
   end Exchange_Certificate;

   -------------------------------
   -- Force_Client_Data_Timeout --
   -------------------------------

   procedure Force_Client_Data_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Force_Client_Data_Timeout).Dur_Value := Value;
   end Force_Client_Data_Timeout;

   ---------------------------------
   -- Force_Client_Header_Timeout --
   ---------------------------------

   procedure Force_Client_Header_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Force_Client_Header_Timeout).Dur_Value := Value;
   end Force_Client_Header_Timeout;

   -----------------------------------
   -- Force_Server_Response_Timeout --
   -----------------------------------

   procedure Force_Server_Response_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Force_Server_Response_Timeout).Dur_Value := Value;
   end Force_Server_Response_Timeout;

   -----------------------------------
   -- Force_Wait_For_Client_Timeout --
   -----------------------------------

   procedure Force_Wait_For_Client_Timeout
     (O     : in out Object;
      Value : Duration) is
   begin
      O.P (Force_Wait_For_Client_Timeout).Dur_Value := Value;
   end Force_Wait_For_Client_Timeout;

   ---------------------------------
   -- Free_Slots_Keep_Alive_Limit --
   ---------------------------------

   procedure Free_Slots_Keep_Alive_Limit
     (O     : in out Object;
      Value : Natural) is
   begin
      O.P (Free_Slots_Keep_Alive_Limit).Nat_Value := Value;
   end Free_Slots_Keep_Alive_Limit;

   ------------------
   -- Hotplug_Port --
   ------------------

   procedure Hotplug_Port (O : in out Object; Value : Positive) is
   begin
      O.P (Hotplug_Port).Pos_Value := Value;
   end Hotplug_Port;

   ----------------------------
   -- Keep_Alive_Force_Limit --
   ----------------------------

   procedure Keep_Alive_Force_Limit (O : in out Object; Value : Natural) is
   begin
      O.P (Hotplug_Port).Nat_Value := Value;
   end Keep_Alive_Force_Limit;

   ---------
   -- Key --
   ---------

   procedure Key (O : in out Object; Filename : String) is
   begin
      O.P (Key).Str_Value := To_Unbounded_String (Filename);
   end Key;

   ---------------------
   -- Line_Stack_Size --
   ---------------------

   procedure Line_Stack_Size (O : in out Object; Value : Positive) is
   begin
      O.P (Line_Stack_Size).Pos_Value := Value;
   end Line_Stack_Size;

   -------------------------
   -- Log_Extended_Fields --
   -------------------------

   procedure Log_Extended_Fields (O : in out Object; Value : String) is
   begin
      Utils.Parse_Strings (O.P (Log_Extended_Fields).Strs_Value, Value);
   end Log_Extended_Fields;

   ------------------------
   -- Log_File_Directory --
   ------------------------

   procedure Log_File_Directory (O : in out Object; Value : String) is
   begin
      O.P (Log_File_Directory).Dir_Value := To_Unbounded_String (Value);
   end Log_File_Directory;

   -------------------------
   -- Log_Filename_Prefix --
   -------------------------

   procedure Log_Filename_Prefix (O : in out Object; Value : String) is
   begin
      O.P (Log_Filename_Prefix).Str_Value := To_Unbounded_String (Value);
   end Log_Filename_Prefix;

   --------------------
   -- Log_Split_Mode --
   --------------------

   procedure Log_Split_Mode (O : in out Object; Value : String) is
   begin
      O.P (Log_Split_Mode).Str_Value := To_Unbounded_String (Value);
   end Log_Split_Mode;

   ----------------
   -- Logo_Image --
   ----------------

   procedure Logo_Image (O : in out Object; Value : String) is
   begin
      O.P (Logo_Image).Str_Value := To_Unbounded_String (Value);
   end Logo_Image;

   --------------------
   -- Max_Connection --
   --------------------

   procedure Max_Connection (O : in out Object; Value : Positive) is
   begin
      O.P (Max_Connection).Pos_Value := Value;
   end Max_Connection;

   ---------------
   -- Parameter --
   ---------------

   procedure Parameter
     (Config        : in out Object;
      Name          : String;
      Value         : String;
      Error_Context : String := "") is
   begin
      Utils.Set_Parameter
        (Config.P, Utils.Value (Name, Error_Context), Value, Error_Context);
   end Parameter;

   procedure Parameter
     (Name          : String;
      Value         : String;
      Error_Context : String := "") is
   begin
      Utils.Set_Parameter
        (Process_Options,
         Utils.Value (Name, Error_Context),
         Value,
         Error_Context);
   end Parameter;

   ---------------------
   -- Receive_Timeout --
   ---------------------

   procedure Receive_Timeout (O : in out Object; Value : Duration) is
   begin
      O.P (Receive_Timeout).Dur_Value := Value;
   end Receive_Timeout;

   -------------------
   -- Reuse_Address --
   -------------------

   procedure Reuse_Address (O : in out Object; Value : Boolean) is
   begin
      O.P (Reuse_Address).Bool_Value := Value;
   end Reuse_Address;

   --------------
   -- Security --
   --------------

   procedure Security (O : in out Object; Value : Boolean) is
   begin
      O.P (Security).Bool_Value := Value;
   end Security;

   -------------------
   -- Security_Mode --
   -------------------

   procedure Security_Mode (O : in out Object; Mode : String) is
   begin
      O.P (Security_Mode).Str_Value := To_Unbounded_String (Mode);
   end Security_Mode;

   ------------------
   -- Send_Timeout --
   ------------------

   procedure Send_Timeout (O : in out Object; Value : Duration) is
   begin
      O.P (Send_Timeout).Dur_Value := Value;
   end Send_Timeout;

   -----------------
   -- Server_Host --
   -----------------

   procedure Server_Host (O : in out Object; Value : String) is
   begin
      O.P (Server_Host).Str_Value := To_Unbounded_String (Value);
   end Server_Host;

   -----------------
   -- Server_Name --
   -----------------

   procedure Server_Name (O : in out Object; Value : String) is
   begin
      O.P (Server_Name).Str_Value := To_Unbounded_String (Value);
   end Server_Name;

   -----------------
   -- Server_Port --
   -----------------

   procedure Server_Port (O : in out Object; Value : Natural) is
   begin
      O.P (Server_Port).Nat_Value := Value;
   end Server_Port;

   -------------
   -- Session --
   -------------

   procedure Session (O : in out Object; Value : Boolean) is
   begin
      O.P (Session).Bool_Value := Value;
   end Session;

   ------------------------------
   -- Session_Cleanup_Interval --
   ------------------------------

   procedure Session_Cleanup_Interval (Value : Duration) is
   begin
      Process_Options (Session_Cleanup_Interval).Dur_Value := Value;
   end Session_Cleanup_Interval;

   ----------------------
   -- Session_Lifetime --
   ----------------------

   procedure Session_Lifetime (Value : Duration) is
   begin
      Process_Options (Session_Lifetime).Dur_Value := Value;
   end Session_Lifetime;

   ------------------
   -- Session_Name --
   ------------------

   procedure Session_Name (O : in out Object; Value : String) is
   begin
      O.P (Session_Name).Str_Value := To_Unbounded_String (Value);
   end Session_Name;

   -----------------
   -- Status_Page --
   -----------------

   procedure Status_Page (O : in out Object; Value : String) is
   begin
      O.P (Status_Page).Str_Value := To_Unbounded_String (Value);
   end Status_Page;

   --------------------------------
   -- Transient_Cleanup_Interval --
   --------------------------------

   procedure Transient_Cleanup_Interval (Value : Duration) is
   begin
      Process_Options (Transient_Cleanup_Interval).Dur_Value := Value;
   end Transient_Cleanup_Interval;

   ------------------------
   -- Transient_Lifetime --
   ------------------------

   procedure Transient_Lifetime (Value : Duration) is
   begin
      Process_Options (Transient_Lifetime).Dur_Value := Value;
   end Transient_Lifetime;

   --------------
   -- Up_Image --
   --------------

   procedure Up_Image (O : in out Object; Value : String) is
   begin
      O.P (Up_Image).Str_Value := To_Unbounded_String (Value);
   end Up_Image;

   ----------------------
   -- Upload_Directory --
   ----------------------

   procedure Upload_Directory (O : in out Object; Value : String) is
   begin
      O.P (Upload_Directory).Dir_Value :=
        To_Unbounded_String (AWS.Utils.Normalized_Directory (Value));
   end Upload_Directory;

   -----------------------
   -- Upload_Size_Limit --
   -----------------------

   procedure Upload_Size_Limit (O : in out Object; Value : Positive) is
   begin
      O.P (Upload_Size_Limit).Pos_Value := Value;
   end Upload_Size_Limit;

   --------------
   -- WWW_Root --
   --------------

   procedure WWW_Root (O : in out Object; Value : String) is
   begin
      O.P (WWW_Root).Dir_Value :=
        To_Unbounded_String (AWS.Utils.Normalized_Directory (Value));
   end WWW_Root;

end AWS.Config.Set;
