------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                     Copyright (C) 2004-2009, AdaCore                     --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;

package body WSDL_8 is

   use Ada.Text_IO;

   ----------
   -- Proc --
   ----------

   procedure Proc
     (Name  : String;
      Files : Set_Of_Files) is
   begin
      Put_Line ("Name : " & Name);

      for K in Files'Range loop
         Put_Line ("K = " & Integer'Image (K));
         Put_Line ("   filename = " & To_String (Files (K).Filename));
         Put_Line ("   content  = " & To_String (Files (K).Content));
      end loop;
   end Proc;

end WSDL_8;
