# /bin/sh
#
# This script creates a tarball and build AWS using this tarball.
# This is used to check wether the MANIFEST file and the tarball for
# distribution is complete.

export BUILD_OPTIONS="DEBUG=1 XMLADA=true ASIS=true"

rm aws-*.tar.gz

rm -fr .build-tarball

# Build current AWS version

svn update
make $BUILD_OPTIONS clean setup build distrib

# Build tarball AWS version, install it

mkdir .build-tarball

cd .build-tarball
export INSTALL="INSTALL=`pwd`/install"

rm -f ../aws-http*
tar xfz ../aws-*.tar.gz
cd aws-*
make $BUILD_OPTIONS $INSTALL setup build install

# Check wether the installed AWS version is working fine

cd ..
mkdir demo
cd demo
cp ../../demos/hello_world* .

cat <<EOF > hello.gpr
with "aws_ssl";
project hello is
   for Source_Dirs use (".");
   for Main use ("hello_world");
end hello;
EOF

export ADA_PROJECT_PATH=$INSTALL/lib/gnat
gnatmake -Phello
