------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2004                            --
--                                ACT-Europe                                --
--                                                                          --
--  Authors: Dmitriy Anisimkov - Pascal Obry                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--
--
--
--
--
--
--

--  Create a password for the hotplug server authorization file

with Ada.Command_Line;
with Ada.Text_IO;

with MD5;

procedure Hotplug_Password is
   use Ada;
   use Ada.Command_Line;
begin
   if Argument_Count /= 2 then
      Text_IO.Put_Line ("Usage: hotplug_password <module> <password>");
   else
      Text_IO.Put_Line
        (MD5.Digest (Argument (1) & ":hotplug:" & Argument (2)));
   end if;
end Hotplug_Password;
