------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2003                            --
--                                ACT-Europe                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--
--
--
--
--
--
--

--  This API control the transient pages cleaner task. Register must
--  be called by each Web server and Shutdown to terminate it. This is
--  done during sever initialization and finalization. Users should
--  not call directly these routines.

package AWS.Services.Transient_Pages.Control is

   procedure Register (Transient_Check_Interval : in Duration);
   --  Register the check interval for the cleaner task, increment server's
   --  count.

   procedure Shutdown;
   --  Stop session cleaner task if there is no more server running

end AWS.Services.Transient_Pages.Control;
