------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2005-2006                          --
--                                 AdaCore                                  --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--
--
--
--
--
--
--

with AWS.Messages;

package body AWS.Services.Dispatchers.Linker is

   use AWS.Dispatchers;

   --------------
   -- Dispatch --
   --------------

   function Dispatch
     (Dispatcher : in Handler;
      Request    : in Status.Data)
      return Response.Data
   is
      use type Messages.Status_Code;
      R : Response.Data;
   begin
      R := AWS.Dispatchers.Dispatch (Dispatcher.First.all, Request);

      if Response.Status_Code (R) /= Messages.S404 then
         return R;
      else
         return AWS.Dispatchers.Dispatch (Dispatcher.Second.all, Request);
      end if;
   end Dispatch;

   --------------
   -- Finalize --
   --------------

   procedure Finalize (Dispatcher : in out Handler) is
   begin
      Finalize (AWS.Dispatchers.Handler (Dispatcher));

      if Ref_Counter (Dispatcher) = 0 then
         Free (Dispatcher.First);
         Free (Dispatcher.Second);
      end if;
   end Finalize;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize (Dispatcher : in out Handler) is
   begin
      Initialize (AWS.Dispatchers.Handler (Dispatcher));
   end Initialize;

   --------------
   -- Register --
   --------------

   procedure Register
     (Dispatcher    : in out Handler;
      First, Second : in     AWS.Dispatchers.Handler'Class) is
   begin
      Dispatcher :=
        (AWS.Dispatchers.Handler with
         new AWS.Dispatchers.Handler'Class'(First),
         new AWS.Dispatchers.Handler'Class'(Second));
   end Register;

end AWS.Services.Dispatchers.Linker;
