------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2006                            --
--                                 AdaCore                                  --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--
--
--
--
--
--
--

with AWS.Net.Thin;

package AWS.Net.Poll_Events is

   type Set (Size : Natural) is new FD_Set with private;

   overriding procedure Add
     (FD_Set : in out Set;
      FD     : in     FD_Type;
      Event  : in     Wait_Event_Set);

   overriding procedure Set_Mode
     (FD_Set : in out Set; Index : in Positive; Mode : in Wait_Event_Set);

   overriding function Copy
     (FD_Set : access Set; Size : in Natural) return FD_Set_Access;

   overriding procedure Remove (FD_Set : in out Set; Index : in Positive);

   overriding function Length (FD_Set : in Set) return Natural;

   overriding procedure Wait
     (FD_Set : in out Set; Timeout : in Duration; Count : out Natural);

   overriding procedure Next (FD_Set : in Set; Index : in out Positive);

   overriding function Status
     (FD_Set : in Set; Index : in Positive) return Event_Set;

private

   type Poll_Set is array (Positive range <>) of Thin.Pollfd;
   pragma Pack (Poll_Set);

   type Set (Size : Natural) is new FD_Set (Size) with record
      Length : Natural := 0;
      Fds    : Poll_Set (1 .. Size);
   end record;

end AWS.Net.Poll_Events;
