------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                            Copyright (C) 2004                            --
--                                ACT-Europe                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--
--
--
--
--
--
--

--  Print all tasks except current.
--
--  Used to detect tasks leaking during the regression tests.
--  This procedure is only for GNAT. It should be reimplemented or emptied
--  for other Ada compilers.

pragma Warnings (Off);
with System.Tasking.Debug;
with System.Task_Primitives.Operations;
pragma Warnings (On);

procedure Print_Tasks is
   use System.Tasking;

   List : Task_ID := All_Tasks_List;
begin
   while List /= null loop

      if List /= System.Task_Primitives.Operations.Self then
         Debug.Print_Task_Info (List);
      end if;

      List := List.Common.All_Tasks_Link;
   end loop;
end Print_Tasks;
