------------------------------------------------------------------------------
--                              Ada Web Server                              --
--                                                                          --
--                         Copyright (C) 2000-2001                          --
--                                ACT-Europe                                --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
--
--
--
--
--
--
--

--  This is a very simple Web Page Server using the AWS.Services.Page_Server.

with Ada.Text_IO;

with AWS.Server;
with AWS.Services.Page_Server;

procedure WPS is

   use Ada;

   WS : AWS.Server.HTTP;

begin
   Text_IO.Put_Line ("AWS " & AWS.Version);
   Text_IO.Put_Line ("Kill me when you want me to stop or press Q...");

   AWS.Services.Page_Server.Directory_Browsing (True);
   --  Comment this to disable the directory browsing facility.

   AWS.Server.Start
     (WS, "Simple Page Server demo",
      Port           => 1234,
      Callback       => AWS.Services.Page_Server.Callback'Access,
      Max_Connection => 5);

   AWS.Server.Wait (AWS.Server.Q_Key_Pressed);

   Text_IO.Put_Line ("AWS server shutdown in progress...");

   AWS.Server.Shutdown (WS);
end WPS;
