------------------------------------------------------------------------------
--                                                                          --
--                          AUNITSTUB COMPONENTS                            --
--                                                                          --
--                    A U N I T S T U B . O P T I O N S                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2008-2011, AdaCore                     --
--                                                                          --
-- AUNITSTUB is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software  Foundation;  either  version  2, or (at your option) any later --
-- version.  AUNITSTUB  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License distributed with GNAT; see file COPYING. If --
-- not, write to the  Free  Software  Foundation, 51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.,                                      --
--                                                                          --
-- AUNITSTUB is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines a set of options for the tool.

with GNAT.OS_Lib;                use GNAT.OS_Lib;

package AUnitStub.Options is

   --  Input options:
   Source_Prj : String_Access := new String'("");
   --  Source project file.

   --  Output options:
   type Output_Mode is (Separate_Root, Parallel, Subdir);

   Default_Output_Mode : constant Output_Mode := Subdir;

   Test_File_Prefix  : String_Access := new String'("test_");
   --  Prefix added to the names of files to get test file names.

   Test_File_Suffix  : String_Access := new String'("");
   --  Suffix added to the names of files to get test file names.

   Test_Dir_Prefix   : String_Access := new String'("");
   --  Prefix added to the names of source dirs to get test dirs names.

   Test_Dir_Suffix   : String_Access := new String'("_test");
   --  Suffix added to the names of source dirs to get test dirs names.

   Test_Subdir_Name  : String_Access := new String'("tests");
   --  Name of subdirectory to place test files in case of --sudbir option.

   Separate_Root_Dir : String_Access;
   --  The root directory to place the test file hierarchy in case of
   --  --separate-root option.

   Quiet : Boolean := False;
   --  When true, supresses non-critical output.

   Test_Case : Boolean := False;
   --  Handling of pragma/aspect Test_Case.

end AUnitStub.Options;
