------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
-- A S I S _ U L . E N V I R O N M E N T . C H E C K  _ P A R A M E T E R S --
--                                                                          --
--            (adapted for gnatsync from ASIS Utility Library)              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Common;
with ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;      use ASIS_UL.Source_Table;

with Gnatsync.Options;
with Gnatsync.Output;           use Gnatsync.Output;
with Gnatsync.Threads;

separate (ASIS_UL.Environment)
procedure Check_Parameters is
begin
   Set_Arg_List;

   if ASIS_UL.Options.Verbose_Mode then
      Print_Version_Info;
   end if;

   if Last_Source < First_SF_Id then
      Error ("No input source file set");
      Brief_Help;
      raise Parameter_Error;
   end if;

   Total_Sources := Natural (Last_Source);
   Sources_Left  := Total_Sources;

   ASIS_UL.Common.Set_Tool_Name ("gnatsync");
   ASIS_UL.Output.Set_Report_File;
   ASIS_UL.Options.Log_Mode := True;
   ASIS_UL.Output.Set_Log_File;

   Gnatsync.Options.Foreign_Threads_Present :=
     Gnatsync.Threads.Foring_Threads_Specified;

   Gnatsync.Options.Foreign_Critical_Sections_Present :=
     Gnatsync.Threads.Foreign_Critical_Sections_Specified;

end Check_Parameters;
