------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--     A S I S _ U L . G L O B A L _ S T A T E . C G . G N A T E L I M      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 1998-2008, AdaCore                     --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to the  Free Software Foundation, 51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

package body ASIS_UL.Global_State.CG.Gnatelim is

   -----------------------
   -- Local subprograms --
   -----------------------

   procedure Mark_As_Used (N : GS_Node_Id);
   --  Mark the node as used.

   procedure Mark_List_As_Used (L : Node_Lists.Set);
   --  Marks all the nodes in the argument set as used

   -------------
   -- Is_Used --
   -------------

   function Is_Used (N : GS_Node_Id) return Boolean renames
     ASIS_UL.Global_State.Get_Application_Flag_1;

   ------------------
   -- Mark_As_Used --
   ------------------

   procedure Mark_As_Used (N : GS_Node_Id) is
   begin
      pragma Assert (Present (N) and then GS_Node_Kind (N) in Callable_Nodes);
      Set_Application_Flag_1 (N, True);
   end Mark_As_Used;

   -----------------------
   -- Mark_List_As_Used --
   -----------------------

   procedure Mark_List_As_Used (L : Node_Lists.Set) is
      Next_Node : Node_Lists.Cursor;
   begin
      Next_Node := Node_Lists.First (L);

      while Node_Lists.Has_Element (Next_Node) loop
         Mark_As_Used (Node_Lists.Element (Next_Node));
         Next_Node := Node_Lists.Next (Next_Node);
      end loop;

   end Mark_List_As_Used;

   ---------------------------
   -- Mark_Used_Subprograms --
   ---------------------------

   procedure Mark_Used_Subprograms is
   begin
      Mark_List_As_Used (Table (Environment_Task_Node).Node_List_1);

      for J in First_GS_Node .. Last_Node loop

         if (Is_Dispatching_Operation_Node (J) and then not Is_Used (J))
           or else
             GS_Node_Kind (J) in
               A_Type_Discr_Init_Procedure .. A_Type_Init_Procedure
         then
            Mark_As_Used (J);
            Mark_List_As_Used (Table (J).Node_List_1);
         end if;

      end loop;

   end Mark_Used_Subprograms;

end ASIS_UL.Global_State.CG.Gnatelim;
