------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS
--                                                                          --
--  A S I S _ U L . E N V I R O N M E N T . S C A N _ P A R A M E T E R S   --
--                                                                          --
--            (adapted for gnatsync from ASIS Utility Library)              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2008-2009, AdaCore                      --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to the  Free Software Foundation, 51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Command_Line;          use GNAT.Command_Line;

with ASIS_UL.Options;            use ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;       use ASIS_UL.Source_Table;

with Gnatelim.Output;            use Gnatelim.Output;

--  with Gnatelim.Options;           use Gnatelim.Options;

separate (ASIS_UL.Environment)
procedure Scan_Parameters is
   No_More_Args : Boolean := True;
begin

   --  For compatibility reasons, pipe mode is the default
   Set_Pipe_Mode;

   Initialize_Option_Scan
     (Stop_At_First_Non_Switch => True,
      Section_Delimiters       => "cargs");

   loop
      case GNAT.Command_Line.Getopt
             ("t v d dd q "  &
              "a "           & --  Process RTL components
              "P: "          & --  Project file
              "l? "          & --  Specifying the log file
              "wq ws wn wf " & --  Warning message control
              "o= "          & --  Specify the output file
              "files= "      & --  Specifies a set of files to process
              "main= "       & --  specifies the main subprogram
              --  obsolete features, for backward compatibility
              "b: I: C: -GCC=: -GNATMAKE= m"
              )
      is

         when ASCII.NUL =>
            exit;
         when 'a' =>
            Process_RTL_Units := True;

         when 'b' =>
            null;  --  obsolete features, for backward compatibility

         when 'C' =>
            --  In old gnatelim this switch has been used to specify a
            --  configuration file, so:
            Store_GNAT_Option_With_Path ("gnatec", Parameter);
         when 'd' =>

            if Full_Switch = "d" then
               Debug_Mode := True;
               Compute_Timing := True;
            elsif Full_Switch = "dd" then
               Progress_Indicator_Mode := True;
            end if;

         when 'f' =>

            if Full_Switch = "files" then
               Read_Args_From_File (Parameter, Store_With_No_Check => True);
            end if;

         when 'I' =>
            Store_I_Option (Parameter);

         when 'l' =>

            if Full_Switch = "l" then
               Log_Mode := True;
               Set_Log_File_Name (Parameter);
               Set_Log_File;
            end if;

         when 'm' =>

            if Full_Switch = "main" then

               if Is_Regular_File (Parameter) then

                  Free (ASIS_UL.Options.Main_Subprogram_Name);

                  ASIS_UL.Options.Main_Subprogram_Name :=
                     new String'(Parameter);
--                     new String'(Normalize_Pathname
--                                   (Parameter,
--                                    Resolve_Links  => False,
--                                    Case_Sensitive => False));
               else
                  Error (Parameter & " not found");
               end if;

            elsif Full_Switch = "m" then
               null; --  Obsolete switch, for backwards compatibility
            end if;

         when 'o' =>

            if Full_Switch = "o" then
               Set_Pipe_Mode (False);
               Set_Report_File_Name (Parameter);
            end if;

         when 'P' =>
            Process_Project_File (Parameter);
         when 'q' =>
            Quiet_Mode := True;

         when 't' =>
            if Full_Switch = "t" then
               Compute_Timing := True;
            end if;

         when 'v' =>
            Verbose_Mode := True;

         when 'w' =>

            if Full_Switch = "wq" then
               Warning_Mode := Quiet;
            elsif Full_Switch = "ws" then
               Warning_Mode := Short;
            elsif Full_Switch = "wn" then
               Warning_Mode := Normal;
            elsif Full_Switch = "wf" then
               Warning_Mode := Full;
            end if;

         when '-' =>

            if Full_Switch = "-GCC" then
               null;  --  obsolete features, for backward compatibility
            elsif Full_Switch = "-GNATMAKE" then
               null;  --  obsolete features, for backward compatibility
            end if;

         when others =>
            raise Parameter_Error;
      end case;
   end loop;

   loop
      Store_Sources_To_Process
        (Get_Argument (Do_Expansion => True), No_More_Args);
      exit when No_More_Args;
   end loop;

   Process_cargs_Section;

exception
   when GNAT.Command_Line.Invalid_Switch =>
      Error ("invalid switch : " & Full_Switch);
      Brief_Help;
      raise Parameter_Error;

   when GNAT.Command_Line.Invalid_Parameter =>
      Error ("missing parameter for: " & Full_Switch);
      raise Parameter_Error;

end Scan_Parameters;
