------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS
--                                                                          --
-- A S I S _ U L . E N V I R O N M E N T . C H E C K  _ P A R A M E T E R S --
--                                                                          --
--            (adapted for gnatelim from ASIS Utility Library)              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2008-2009, AdaCore                      --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to the  Free Software Foundation, 51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Common;
with ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;      use ASIS_UL.Source_Table;

with Gnatelim.Options;
with Gnatelim.Output;           use Gnatelim.Output;

separate (ASIS_UL.Environment)
procedure Check_Parameters is
begin

   Process_ADA_PRJ_INCLUDE_FILE;

   Set_Arg_List;

   Set_Source_Search_Path;

   Read_Args_From_Temp_Storage (Duplication_Report => False);

   if ASIS_UL.Options.Verbose_Mode then
      ASIS_UL.Output.Print_Version_Info (1997);
   end if;

   if ASIS_UL.Options.Main_Subprogram_Name = null
     and then
      Last_Source /= First_SF_Id
   then
      Error ("No main unit specificed");
      Brief_Help;
      raise Parameter_Error;
   end if;

   if ASIS_UL.Options.Main_Subprogram_Name /= null
     and then
      Last_Source < First_SF_Id
   then
      Gnatelim.Options.Compute_Closure := True;
   elsif ASIS_UL.Options.Main_Subprogram_Name = null
     and then
      Last_Source = First_SF_Id
   then
      ASIS_UL.Options.Main_Subprogram_Name :=
        new String'(Source_Name (Last_Source));
      Gnatelim.Options.Compute_Closure := True;
   end if;

   Total_Sources := Natural (Last_Source);
   Sources_Left  := Total_Sources;

   ASIS_UL.Output.Set_Report_File;

   ASIS_UL.Options.Nothing_To_Do := Last_Source < First_SF_Id;
end Check_Parameters;
