------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                          A 4 G . Q U E R I E S                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (C) 1995-2012, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License  distributed with ASIS-for-GNAT; see   file --
-- COPYING.  If not,  write  to the  Free Software Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences. ASIS-for-GNAT is now maintained by AdaCore                     --
-- (http://www.adaccore.com).                                               --
--                                                                          --
-- The original version of this component has been developed by Jean-Charles--
-- Marteau (Jean-Charles.Marteau@ensimag.imag.fr) and Serge Reboul          --
-- (Serge.Reboul@ensimag.imag.fr), ENSIMAG High School Graduates (Computer  --
-- sciences) Grenoble, France in Sema Group Grenoble, France. Now this      --
-- component is maintained by the ASIS team                                 --
--                                                                          --
------------------------------------------------------------------------------

pragma Ada_2012;

with Asis; use Asis;

----------------------------------------------------------
-- The goal of this package is, when we have an element --
-- to let us have ALL the possible queries for that     --
-- element that return its children.                    --
----------------------------------------------------------

with Asis.Extensions.Flat_Kinds; use Asis.Extensions.Flat_Kinds;

package A4G.Queries is

   --  Structural_Queries is an enumeration of all the structural (syntactic)
   --  queries. Note that these enumeration literals are overloaded with the
   --  names of the query functions themselves. So for example, there is a
   --  function Clause_Names in Asis.Clauses, and there is a corresponding
   --  enumeration literal Clause_Names below.

   type Structural_Queries is
     (No_Query,

      --  The following are queries of Compilation_Unit

      Context_Clause_Elements,
      Unit_Declaration,

      --  The following are used only by gnat2xml, which treats ASIS "traits"
      --  somewhat like queries. These are not used in ASIS itself.

      Aliased_Trait,
      Not_Null,
      Reverse_Trait,
      Limited_Trait,
      Abstract_Trait,

      --  The rest below are the normal queries of Elements

      --  Queries in A4G.Queries:
      All_But_First_Associations,
      First_Parameter_Association,

      --  Queries in Asis.Clauses:
      Clause_Names,
      Component_Clause_Position,
      Component_Clause_Range,
      Component_Clauses,
      Mod_Clause_Expression,
      Representation_Clause_Expression,
      Representation_Clause_Name,

      --  Queries in Asis.Declarations:
      Aspect_Specifications,
      Body_Declarative_Items,
      Body_Exception_Handlers,
      Body_Statements,
      Declaration_Interface_List,
      Defining_Prefix,
      Defining_Selector,
      Discriminant_Part,
      Entry_Barrier,
      Entry_Family_Definition,
      Entry_Index_Specification,
      Generic_Actual_Part,
      Generic_Formal_Part,
      Generic_Unit_Name,
      Initialization_Expression,
      Iteration_Scheme_Name,
      Names,
      Object_Declaration_View,
      Parameter_Profile,
      Private_Part_Declarative_Items,
      Protected_Operation_Items,
      Renamed_Entity,
      Result_Expression,
      Result_Profile,
      Specification_Subtype_Definition,
      Subtype_Indication,
      Type_Declaration_View,
      Visible_Part_Declarative_Items,

      --  Queries in Asis.Definitions:
      Access_To_Function_Result_Profile,
      Access_To_Object_Definition,
      Access_To_Subprogram_Parameter_Profile,
      Ancestor_Subtype_Indication,
      Anonymous_Access_To_Object_Subtype_Mark,
      Array_Component_Definition,
      Aspect_Definition,
      Aspect_Mark,
      Component_Definition_View,
      Definition_Interface_List,
      Delta_Expression,
      Digits_Expression,
      Discrete_Ranges,
      Discrete_Subtype_Definitions,
      Discriminant_Associations,
      Discriminant_Direct_Name,
      Discriminants,
      Enumeration_Literal_Declarations,
      Index_Subtype_Definitions,
      Integer_Constraint,
      Lower_Bound,
      Mod_Static_Expression,
      Parent_Subtype_Indication,
      Private_Part_Items,
      Range_Attribute,
      Real_Range_Constraint,
      Record_Components,
      Record_Definition,
      Subtype_Constraint,
      Subtype_Mark,
      Upper_Bound,
      Variant_Choices,
      Variants,
      Visible_Part_Items,

      --  Queries in Asis.Elements:
      Pragma_Argument_Associations,

      --  Queries in Asis.Expressions:
      Actual_Parameter,
      Allocator_Qualified_Expression,
      Allocator_Subtype_Indication,
      Array_Component_Associations,
      Array_Component_Choices,
      Attribute_Designator_Expressions,
      Attribute_Designator_Identifier,
      Component_Expression,
      Converted_Or_Qualified_Expression,
      Converted_Or_Qualified_Subtype_Mark,
      Dependent_Expression,
      Discriminant_Expression,
      Discriminant_Selector_Names,
      Expression_Parenthesized,
      Expression_Paths,
      Extension_Aggregate_Expression,
      Formal_Parameter,
      Function_Call_Parameters,
      Index_Expressions,
      Iterator_Specification,
      Membership_Test_Choices,
      Membership_Test_Expression,
      Predicate,
      Prefix,
      Record_Component_Associations,
      Record_Component_Choices,
      Selector,
      Short_Circuit_Operation_Left_Expression,
      Short_Circuit_Operation_Right_Expression,
      Slice_Range,
      Subpool_Name,

      --  Queries in Asis.Extensions:
      Formal_Subprogram_Default,

      --  Queries in Asis.Statements:
      Aborted_Tasks,
      Accept_Body_Exception_Handlers,
      Accept_Body_Statements,
      Accept_Entry_Direct_Name,
      Accept_Entry_Index,
      Accept_Parameters,
      Assignment_Expression,
      Assignment_Variable_Name,
      Associated_Message,
      Block_Declarative_Items,
      Block_Exception_Handlers,
      Block_Statements,
      Called_Name,
      Call_Statement_Parameters,
      Case_Expression,
      Case_Path_Alternative_Choices,
      Choice_Parameter_Specification,
      Condition_Expression,
      Delay_Expression,
      Exception_Choices,
      Exit_Condition,
      Exit_Loop_Name,
      Extended_Return_Exception_Handlers,
      Extended_Return_Statements,
      For_Loop_Parameter_Specification,
      Goto_Label,
      Guard,
      Handler_Statements,
      Label_Names,
      Loop_Statements,
      Qualified_Expression,
      Raised_Exception,
      Requeue_Entry_Name,
      Return_Expression,
      Return_Object_Declaration,
      Sequence_Of_Statements,
      Statement_Identifier,
      Statement_Paths,
      While_Condition
     ); -- end Structural_Queries

   subtype Trait_Queries is Structural_Queries with
     Predicate => Trait_Queries in
                    Aliased_Trait |
                    Not_Null      |
                    Reverse_Trait |
                    Limited_Trait |
                    Abstract_Trait;

   type All_Query_Kinds is
     (Bug,
      --  just for the discriminant default expression
      Single_Element_Query,
      --  Queries taking an element and returning an element.
      Element_List_Query,
      --  Queries taking an element and returning a list of elements.
      Element_List_Query_With_Boolean,
      --  Queries taking an element and a boolean and returning a list
      --  of elements.
      Single_Element_CU_Query,
      --  Queries taking Compilation_Unit and returning an element.
      Element_List_CU_Query
      --  Queries taking a Compilation_Unit and returning a list of elements.
    );
   subtype Query_Kinds is All_Query_Kinds range
     Bug .. Element_List_Query_With_Boolean;
   subtype CU_Query_Kinds is All_Query_Kinds range
     Single_Element_CU_Query .. Element_List_CU_Query;

   type A_Single_Element_CU_Query is access
      function (Elem : Asis.Compilation_Unit) return Asis.Element;

   type A_Element_List_CU_Query is access
      function
        (Elem : Asis.Compilation_Unit;
         Bool : Boolean)
         return Asis.Element_List;

   type A_Single_Element_Query is access
      function (Elem : Asis.Element) return Asis.Element;

   type A_Element_List_Query is access
      function (Elem : Asis.Element) return Asis.Element_List;

   type A_Element_List_Query_With_Boolean is access
      function
        (Elem : Asis.Element;
         Bool : Boolean)
         return Asis.Element_List;

   --  Discriminated record that can access any type of query.
   type Func_Elem
     (Q : Structural_Queries := Structural_Queries'First;
      Query_Kind : All_Query_Kinds := Bug)
   is
      record
         case Query_Kind is
            when Bug =>
               null;
            when Single_Element_CU_Query =>
               Func_Simple_CU : A_Single_Element_CU_Query;
            when Element_List_CU_Query =>
               Func_List_CU : A_Element_List_CU_Query;
            when Single_Element_Query =>
               Func_Simple : A_Single_Element_Query;
            when Element_List_Query =>
               Func_List : A_Element_List_Query;
            when Element_List_Query_With_Boolean =>
               Func_List_Boolean : A_Element_List_Query_With_Boolean;
               Bool : Boolean;
         end case;
      end record;

   type Query_Index is new Positive;
   type Func_Elem_Array is array (Query_Index range <>) of Func_Elem;

   type Query_List is array (Query_Index range <>) of Structural_Queries;
   type Query_List_Ptr is access constant Query_List;

   No_Queries : aliased constant Query_List :=
     (1 .. 0 => No_Query);

   --  Appropriate_Queries returns the sequence of syntactic queries that
   --  applies to a given element or element kind. Syntactic determines the
   --  handling of prefix-notation calls; see Asis.Extensions.Iterator for
   --  details.

   function Appropriate_Queries
     (Kind : Flat_Element_Kinds) return Query_List_Ptr;
   --  This version operates on an element kind, and behaves as if Syntactic is
   --  False.

   function Appropriate_Queries
     (Element : Asis.Element; Syntactic : Boolean)
     return Query_List_Ptr;
   --  This version operates on an element, and takes the Syntactic parameter
   --  into account.

   function Appropriate_Queries
     (Element : Asis.Element; Syntactic : Boolean := True)
     return Func_Elem_Array;
   --  This version is similar to the previous one, but returns the information
   --  in a different form (a Func_Elem_Array instead of a Query_List_Ptr).
   --  ???We can probably get rid of this last one at some point.

   function Get_Func_Elem (Q : Structural_Queries) return Func_Elem;
   --  Get the Func_Elem corresponding to the given query, showing the
   --  parameter and result type profile, and the actual Ada function to call.

end A4G.Queries;
