------------------------------------------------------------------------------
--                                                                          --
--                           GNATTEST COMPONENTS                            --
--                                                                          --
--                      G N A T T E S T . C O M M O N                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- GNATTEST  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software  Foundation;  either  version  2, or (at your option) any later --
-- version.  GNATTEST  is  distributed  in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License distributed with GNAT; see file COPYING. If --
-- not, write to the  Free  Software  Foundation, 51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.,                                      --
--                                                                          --
-- GNATTEST is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains some general-purpose entities that are used by many
--  GNATtest components

with Asis;

with Ada.Exceptions;              use Ada.Exceptions;
with GNAT.OS_Lib;                 use GNAT.OS_Lib;
with Ada.Text_IO;                 use Ada.Text_IO;

with Ada.Containers.Indefinite_Doubly_Linked_Lists;

package GNATtest.Common is

   procedure Report_Err (Message : String);
   --  Prints it's argument to the standard error output

   procedure Report_AUnit_Usage;
   --  Shows a message about AUnit being among the source files

   procedure Report_Std (Message : String; Offset : Integer := 0);
   --  Prints it's argument to the standard output with Offset spaces before.

   procedure Report_Unhandled_ASIS_Exception (Ex : Exception_Occurrence);
   --  Reports an unhandled ASIS exception

   procedure Report_Unhandled_Exception (Ex : Exception_Occurrence);
   --  Reports an unhandled non-ASIS exception

   procedure Generate_Common_File;
   --  Creates a file with package gnattest_generated which denotes the default
   --  stubs behavior and declares renamins necessary to avoid name conflicts
   --  with tested sources.

   The_Context : Asis.Context;
   --  The Context for all the processing. May be associated, opened, closed
   --  and dissociated several times during one tool run.

   Fatal_Error : exception;

   Test_Prj_Prefix         : constant String := "test_";
   --  Prefix of the output project file name.

   Tmp_Test_Prj : String_Access := null;

   Output_File : File_Type;

   procedure S_Put (Span : Natural; Text : String);
   --  Adds Span number spaces before the Text and prints it to Output_File

   function Unit_To_File_Name (Old : String) return String;
   --  Replaces dots with "-" and lowers the case of the letters.

   package List_Of_Strings is new
     Ada.Containers.Indefinite_Doubly_Linked_Lists (String);
   use List_Of_Strings;

   Inherited_Switches : List_Of_Strings.List;

end GNATtest.Common;
