------------------------------------------------------------------------------
--                                                                          --
--                          AUNITGLUE COMPONENTS                            --
--                                                                          --
--                     A U N I T G L U E . D R I V E R                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2008-2010, AdaCore                     --
--                                                                          --
-- AUNITGLUE is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software  Foundation;  either  version  2, or (at your option) any later --
-- version.  AUNITGLUE  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General  Public License distributed with GNAT; see file COPYING. If --
-- not, write to the  Free  Software  Foundation, 51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.,                                      --
--                                                                          --
-- AUNITGLUE is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Command_Line;

with Asis.Exceptions;

with AUnitGlue.Environment;
with AUnitGlue.Generator;
with AUnitGlue.Common;

procedure AUnitGlue.Driver is
begin
   AUnitGlue.Environment.Initialize;
   AUnitGlue.Generator.Process_Sources;
   AUnitGlue.Environment.Clean_Up;
   Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Success);
exception
   when AUnitGlue.Common.Fatal_Error =>
      --  Just a trap; all the diagnostic messages should already
      --  have been generated.
      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      AUnitGlue.Environment.Clean_Up;

   when Ex : Asis.Exceptions.ASIS_Inappropriate_Context          |
             Asis.Exceptions.ASIS_Inappropriate_Container        |
             Asis.Exceptions.ASIS_Inappropriate_Compilation_Unit |
             Asis.Exceptions.ASIS_Inappropriate_Element          |
             Asis.Exceptions.ASIS_Inappropriate_Line             |
             Asis.Exceptions.ASIS_Inappropriate_Line_Number      |
             Asis.Exceptions.ASIS_Failed                         =>

      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      AUnitGlue.Common.Report_Unhandled_ASIS_Exception (Ex);
      AUnitGlue.Environment.Clean_Up;

   when Ex : others =>
      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      AUnitGlue.Common.Report_Unhandled_Exception (Ex);
      AUnitGlue.Environment.Clean_Up;

end AUnitGlue.Driver;
