------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS
--                                                                          --
-- A S I S _ U L . E N V I R O N M E N T . C H E C K  _ P A R A M E T E R S --
--                                                                          --
--            (adapted for gnatelim from ASIS Utility Library)              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2008-2010, AdaCore                      --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to the  Free Software Foundation, 51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Common;
with ASIS_UL.Options;
with ASIS_UL.Output;
with ASIS_UL.Source_Table;

with Gnatelim.Options;
with Gnatelim.Output;           use Gnatelim.Output;

separate (ASIS_UL.Environment)
procedure Check_Parameters is
   Tmp      : String_Access;
   Tmp_Bool : Boolean;
begin

   Read_Args_From_Temp_Storage (Duplication_Report => False);

   if ASIS_UL.Options.Verbose_Mode then
      ASIS_UL.Output.Print_Version_Info (1997);
   end if;

   if ASIS_UL.Options.Main_Subprogram_Name /= null then

      Free (Tmp);

      if not Is_Regular_File (ASIS_UL.Options.Main_Subprogram_Name.all) then

         if Source_Search_Path /= null then
            Tmp := Locate_Regular_File
                    (File_Name => ASIS_UL.Options.Main_Subprogram_Name.all,
                     Path      => Source_Search_Path.all);
         end if;

         if Tmp = null then
            Error ("file specified as main subprogram not found (" &
                   ASIS_UL.Options.Main_Subprogram_Name.all & ")");
            raise Fatal_Error;
         else
            Free (ASIS_UL.Options.Main_Subprogram_Name);
            ASIS_UL.Options.Main_Subprogram_Name := new String'
              (Normalize_Pathname
                 (Tmp.all,
                  Resolve_Links  => False,
                  Case_Sensitive => False));
            Free (Tmp);
         end if;

      else
         Tmp :=
           new String'(Normalize_Pathname
                         (ASIS_UL.Options.Main_Subprogram_Name.all,
                          Resolve_Links  => False,
                          Case_Sensitive => False));

         Free (ASIS_UL.Options.Main_Subprogram_Name);
         ASIS_UL.Options.Main_Subprogram_Name := new String'(Tmp.all);
      end if;

--    Tmp := new String'(Base_Name (ASIS_UL.Options.Main_Subprogram_Name.all));
--    Free (ASIS_UL.Options.Main_Subprogram_Name);
--    ASIS_UL.Options.Main_Subprogram_Name := new String'(Tmp.all);
      Free (Tmp);

   end if;

   if ASIS_UL.Options.Main_Subprogram_Name = null
     and then
      Last_Source /= First_SF_Id
   then
      Error ("No main unit specificed");
      Brief_Help;
      raise Parameter_Error;
   end if;

   if ASIS_UL.Options.Main_Subprogram_Name /= null
     and then
      Last_Source < First_SF_Id
   then
      Gnatelim.Options.Compute_Closure := True;
   elsif ASIS_UL.Options.Main_Subprogram_Name = null
     and then
      Last_Source = First_SF_Id
   then
      ASIS_UL.Options.Main_Subprogram_Name :=
        new String'(Source_Name (Last_Source));
      Gnatelim.Options.Compute_Closure := True;
   end if;

   pragma Warnings (Off, Tmp_Bool);

   Add_Source_To_Process
     (Fname              => ASIS_UL.Options.Main_Subprogram_Name.all,
      No_Argument        => Tmp_Bool,
      Duplication_Report => False);

   Total_Sources := Natural (Last_Source);
   Sources_Left  := Total_Sources;

   ASIS_UL.Output.Set_Report_File;

   ASIS_UL.Options.Nothing_To_Do :=
     Last_Source < First_SF_Id
    and then
     ASIS_UL.Options.Main_Subprogram_Name = null;
end Check_Parameters;
