------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                    G N A T C H E C K. O P T I O N S                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2004-2009, AdaCore                     --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines options that are supposed to be of a common interest
--  for all the tools.

with GNAT.OS_Lib;

with Gnatcheck.Rules;

package Gnatcheck.Options is

   Generate_Rules_Help : Boolean := False;
   --  '-h'
   --  Generate the rules help information (note, that we can do it only after
   --  registering the rules)

   Generate_Category_Help : Boolean := False;
   --  ''-hcr'
   --  Generate the rule categories help information (note, that we can do it
   --  only after registering the rules). Depending on the flag Recursive_Help,
   --  help information may or may not contain full details for each category.

   Recursive_Help : Boolean := False;
   --  '-hcr'

   Rule_Report_Status : Gnatcheck.Rules.Rule_Statuses :=
      Gnatcheck.Rules.Fully_Implemented;
   --  '-hcr1', '-hcr2'
   --  When generating recursive category help, report rules with the status
   --  equal to or greater then Rule_Report_Status

   Generate_Global_Structure_Warnings : Boolean := False;
   --  ???
   --  Generate warning messages in case if a problem that prevents the
   --  complete analyzis of the program global structure is detected

   Active_Rule_Present : Boolean := False;
   --  Flag indicating idicating if the tool has an activated rule to check.
   --  It does not take into account compiler check, use
   --  Gnatcheck.Compiler.Analyze_Compiler_Output to see if any of the compiler
   --  check is active.

   Analyse_Expanded_Code : Boolean := False;
   --  If this flag is ON, gnatcheck analyses expanded spec and expanded body
   --  for generic instantiations

   --------------------------------------
   -- Controlling the gnatcheck report --
   --------------------------------------

   Qualification_Report : Boolean := True;
   --  '--old-report-format'  (turns it OFF)
   --  If this flag is ON, the qualification report file is created instead of
   --  regular one

   Short_Report : Boolean := False;
   --  '-s'
   --  Print the short version of the report file. For new format of the report
   --  file - only diagnoses are inluded in the report file. For old format -
   --  no header, no lists of endblaed and disabled rules, no list of checked
   --  sources, no introductory paragraph for for the sections

   Max_Diagnoses : Natural := 500;
   --  '-m'
   --  Maximum number of diagnoses to print out into Stdout. Zero means that
   --  there is no limitation on the number of diagnoses to be printed out into
   --  Stderr.

   User_Info_File           : GNAT.OS_Lib.String_Access;
   User_Info_File_Full_Path : GNAT.OS_Lib.String_Access;
   --  --include-file=<filename>
   --  Name of the user-provided text file to be added as the last (???)
   --  section of the report file. If this option is not set, this section is
   --  not created in the report file.

   -----------------------------------------------------------
   --  Options related to the old format of the report file --
   -----------------------------------------------------------

   Output_Section_1 : Boolean := True;
   Output_Section_2 : Boolean := True;
   Output_Section_3 : Boolean := True;
   --  '-sn, n = 1, 2 or 3
   --  Print only specified sections, if at least one '-sn' option is set. Does
   --  not silently impose '-s'.

   Full_Source_Locations : Boolean := False;
   --  '-l'
   --  If this flag is set ON, gnatcheck adds full source locations in the
   --  report file. In case of an entity declared in the expanded generic
   --  code the full location indicates the location of a construct in the
   --  template and then - the location of the corresponding instantiation of
   --  the template (long location chains are used in case of nested
   --  instantiations). Short location shows only the location of the
   --  corresponding construct in the instantiation.

   No_Column_Num_In_Diagnoses : Boolean := False;
   --  '--no-column'
   --  If this flag is ON, the column number is cut off from the diagnostic
   --  messages. Is needed for qualification tests.

end Gnatcheck.Options;
