-----------------------------------------------------------------------
--              GtkAda - Ada95 binding for Gtk+/Gnome                --
--                                                                   --
--                     Copyright (C) 2001                            --
--                         ACT-Europe                                --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-----------------------------------------------------------------------

with System;
with Gtk; use Gtk;

package body Gnome.Window is

   use Gtk.Window;

   ------------------------
   -- Toplevel_Set_Title --
   ------------------------

   procedure Toplevel_Set_Title
     (W         : access Gtk_Window_Record'Class;
      Doc_Name  : String;
      App_Name  : String;
      Extension : String)
   is
      procedure Internal
        (W         : System.Address;
         Doc_Name  : String;
         App_Name  : String;
         Extension : String);
      pragma Import (C, Internal, "gnome_window_toplevel_set_title");
   begin
      Internal (Get_Object (W),
                Doc_Name & ASCII.NUL,
                App_Name & ASCII.NUL,
                Extension & ASCII.NUL);
   end Toplevel_Set_Title;

end Gnome.Window;
