-----------------------------------------------------------------------
--              GtkAda - Ada95 binding for Gtk+/Gnome                --
--                                                                   --
--                     Copyright (C) 2001                            --
--                         ACT-Europe                                --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-----------------------------------------------------------------------

with Gtk; use Gtk;
with System;

package body Gnome.Message_Box is

   ---------------
   -- Gnome_New --
   ---------------

   procedure Gnome_New
     (Widget          : out Gnome_Message_Box;
      Message         : String;
      Messagebox_Type : String;
      Buttons         : Chars_Ptr_Array)
   is
   begin
      Widget := new Gnome_Message_Box_Record;
      Initialize (Widget, Message, Messagebox_Type, Buttons);
   end Gnome_New;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (Widget          : access Gnome_Message_Box_Record'Class;
      Message         : String;
      Messagebox_Type : String;
      Buttons         : Chars_Ptr_Array)
   is
      function Internal
        (Message         : String;
         Messagebox_Type : String;
         Buttons         : Chars_Ptr_Array)
         return System.Address;
      pragma Import (C, Internal, "gnome_message_box_newv");
   begin
      Set_Object (Widget, Internal (Message & ASCII.NUL,
                                    Messagebox_Type & ASCII.NUL,
                                    Buttons + Null_Ptr));
   end Initialize;

end Gnome.Message_Box;
