-----------------------------------------------------------------------
--               GtkAda - Ada95 binding for Gtk+/Gnome               --
--                                                                   --
--   Copyright (C) 1998-2000 E. Briot, J. Brobecker and A. Charlet   --
--                Copyright (C) 2000-2001 ACT-Europe                 --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--
--
--
--
--
--
--
-----------------------------------------------------------------------

with System;
with Glib.Type_Conversion_Hooks;
pragma Elaborate_All (Glib.Type_Conversion_Hooks);

package body Gtk.Item is

   -----------------------
   -- Local Subprograms --
   -----------------------

   function Type_Conversion (Type_Name : String) return GObject;
   --  This function is used to implement a minimal automated type conversion
   --  without having to drag the whole Gtk.Type_Conversion package for the
   --  most common widgets.

   -----------------
   -- Item_Select --
   -----------------

   procedure Item_Select (Item : access Gtk_Item_Record) is
      procedure Internal (Item : System.Address);
      pragma Import (C, Internal, "gtk_item_select");

   begin
      Internal (Get_Object (Item));
   end Item_Select;

   -------------------
   -- Item_Deselect --
   -------------------

   procedure Item_Deselect (Item : access Gtk_Item_Record) is
      procedure Internal (Item : System.Address);
      pragma Import (C, Internal, "gtk_item_deselect");

   begin
      Internal (Get_Object (Item));
   end Item_Deselect;

   ------------
   -- Toggle --
   ------------

   procedure Toggle (Item : access Gtk_Item_Record) is
      procedure Internal (Item : System.Address);
      pragma Import (C, Internal, "gtk_item_toggle");

   begin
      Internal (Get_Object (Item));
   end Toggle;

   ---------------------
   -- Type_Conversion --
   ---------------------

   function Type_Conversion (Type_Name : String) return GObject is
   begin
      if Type_Name = "GtkItem" then
         return new Gtk_Item_Record;
      else
         return null;
      end if;
   end Type_Conversion;

begin
   Glib.Type_Conversion_Hooks.Add_Hook (Type_Conversion'Access);
end Gtk.Item;
