-----------------------------------------------------------------------
--               GtkAda - Ada95 binding for Gtk+/Gnome               --
--                                                                   --
--   Copyright (C) 1998-2000 E. Briot, J. Brobecker and A. Charlet   --
--                Copyright (C) 2000-2006 AdaCore                    --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--
--
--
--
--
--
--
-----------------------------------------------------------------------

--  <description>
--  Base class for containers that have only one child.
--  This widget can not be instantiated directly.
--  </description>
--  <c_version>2.8.17</c_version>
--  <group>Abstract base classes</group>

with Gtk.Widget; use Gtk.Widget;
with Gtk.Container; use Gtk.Container;

package Gtk.Bin is

   type Gtk_Bin_Record is new Container.Gtk_Container_Record with private;
   type Gtk_Bin is access all Gtk_Bin_Record'Class;

   function Get_Type return Gtk.Gtk_Type;
   --  Return the internal value associated with a Gtk_Bin.

   function Get_Child (Bin : access Gtk_Bin_Record) return Gtk_Widget;
   --  Return the child associated with Bin.

   ----------------
   -- Properties --
   ----------------

   --  <properties>
   --  The following properties are defined for this widget. See
   --  Glib.Properties for more information on properties.
   --  </properties>

   -------------
   -- Signals --
   -------------

   --  <signals>
   --  The following new signals are defined for this widget:
   --  </signals>

private
   type Gtk_Bin_Record is new Container.Gtk_Container_Record with null record;
   pragma Import (C, Get_Type, "gtk_bin_get_type");
end Gtk.Bin;
