-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                     Copyright (C) 1998-1999                       --
--        Emmanuel Briot, Joel Brobecker and Arnaud Charlet          --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
--
--
--
--
--
--
--
-----------------------------------------------------------------------

--  <group>Gdk, the low-level API</group>

package Gdk.Types.Keysyms is

   GDK_VoidSymbol                      : constant Gdk_Key_Type := 16#FFFFFF#;
   GDK_BackSpace                       : constant Gdk_Key_Type := 16#FF08#;
   GDK_Tab                             : constant Gdk_Key_Type := 16#FF09#;
   GDK_Linefeed                        : constant Gdk_Key_Type := 16#FF0A#;
   GDK_Clear                           : constant Gdk_Key_Type := 16#FF0B#;
   GDK_Return                          : constant Gdk_Key_Type := 16#FF0D#;
   GDK_Pause                           : constant Gdk_Key_Type := 16#FF13#;
   GDK_Scroll_Lock                     : constant Gdk_Key_Type := 16#FF14#;
   GDK_Sys_Req                         : constant Gdk_Key_Type := 16#FF15#;
   GDK_Escape                          : constant Gdk_Key_Type := 16#FF1B#;
   GDK_Delete                          : constant Gdk_Key_Type := 16#FFFF#;
   GDK_Multi_Key                       : constant Gdk_Key_Type := 16#FF20#;
   GDK_Kanji                           : constant Gdk_Key_Type := 16#FF21#;
   GDK_Muhenkan                        : constant Gdk_Key_Type := 16#FF22#;
   GDK_Henkan_Mode                     : constant Gdk_Key_Type := 16#FF23#;
   GDK_Henkan                          : constant Gdk_Key_Type := 16#FF23#;
   GDK_Romaji                          : constant Gdk_Key_Type := 16#FF24#;
   GDK_Hiragana                        : constant Gdk_Key_Type := 16#FF25#;
   GDK_Katakana                        : constant Gdk_Key_Type := 16#FF26#;
   GDK_Hiragana_Katakana               : constant Gdk_Key_Type := 16#FF27#;
   GDK_Zenkaku                         : constant Gdk_Key_Type := 16#FF28#;
   GDK_Hankaku                         : constant Gdk_Key_Type := 16#FF29#;
   GDK_Zenkaku_Hankaku                 : constant Gdk_Key_Type := 16#FF2A#;
   GDK_Touroku                         : constant Gdk_Key_Type := 16#FF2B#;
   GDK_Massyo                          : constant Gdk_Key_Type := 16#FF2C#;
   GDK_Kana_Lock                       : constant Gdk_Key_Type := 16#FF2D#;
   GDK_Kana_Shift                      : constant Gdk_Key_Type := 16#FF2E#;
   GDK_Eisu_Shift                      : constant Gdk_Key_Type := 16#FF2F#;
   GDK_Eisu_Toggle                     : constant Gdk_Key_Type := 16#FF30#;
   GDK_Home                            : constant Gdk_Key_Type := 16#FF50#;
   GDK_Left                            : constant Gdk_Key_Type := 16#FF51#;
   GDK_Up                              : constant Gdk_Key_Type := 16#FF52#;
   GDK_Right                           : constant Gdk_Key_Type := 16#FF53#;
   GDK_Down                            : constant Gdk_Key_Type := 16#FF54#;
   GDK_Prior                           : constant Gdk_Key_Type := 16#FF55#;
   GDK_Page_Up                         : constant Gdk_Key_Type := 16#FF55#;
   GDK_Next                            : constant Gdk_Key_Type := 16#FF56#;
   GDK_Page_Down                       : constant Gdk_Key_Type := 16#FF56#;
   GDK_End                             : constant Gdk_Key_Type := 16#FF57#;
   GDK_Begin                           : constant Gdk_Key_Type := 16#FF58#;
   GDK_Select                          : constant Gdk_Key_Type := 16#FF60#;
   GDK_Print                           : constant Gdk_Key_Type := 16#FF61#;
   GDK_Execute                         : constant Gdk_Key_Type := 16#FF62#;
   GDK_Insert                          : constant Gdk_Key_Type := 16#FF63#;
   GDK_Undo                            : constant Gdk_Key_Type := 16#FF65#;
   GDK_Redo                            : constant Gdk_Key_Type := 16#FF66#;
   GDK_Menu                            : constant Gdk_Key_Type := 16#FF67#;
   GDK_Find                            : constant Gdk_Key_Type := 16#FF68#;
   GDK_Cancel                          : constant Gdk_Key_Type := 16#FF69#;
   GDK_Help                            : constant Gdk_Key_Type := 16#FF6A#;
   GDK_Break                           : constant Gdk_Key_Type := 16#FF6B#;
   GDK_Mode_Switch                     : constant Gdk_Key_Type := 16#FF7E#;
   GDK_Script_Switch                   : constant Gdk_Key_Type := 16#FF7E#;
   GDK_Num_Lock                        : constant Gdk_Key_Type := 16#FF7F#;
   GDK_KP_Space                        : constant Gdk_Key_Type := 16#FF80#;
   GDK_KP_Tab                          : constant Gdk_Key_Type := 16#FF89#;
   GDK_KP_Enter                        : constant Gdk_Key_Type := 16#FF8D#;
   GDK_KP_F1                           : constant Gdk_Key_Type := 16#FF91#;
   GDK_KP_F2                           : constant Gdk_Key_Type := 16#FF92#;
   GDK_KP_F3                           : constant Gdk_Key_Type := 16#FF93#;
   GDK_KP_F4                           : constant Gdk_Key_Type := 16#FF94#;
   GDK_KP_Home                         : constant Gdk_Key_Type := 16#FF95#;
   GDK_KP_Left                         : constant Gdk_Key_Type := 16#FF96#;
   GDK_KP_Up                           : constant Gdk_Key_Type := 16#FF97#;
   GDK_KP_Right                        : constant Gdk_Key_Type := 16#FF98#;
   GDK_KP_Down                         : constant Gdk_Key_Type := 16#FF99#;
   GDK_KP_Prior                        : constant Gdk_Key_Type := 16#FF9A#;
   GDK_KP_Page_Up                      : constant Gdk_Key_Type := 16#FF9A#;
   GDK_KP_Next                         : constant Gdk_Key_Type := 16#FF9B#;
   GDK_KP_Page_Down                    : constant Gdk_Key_Type := 16#FF9B#;
   GDK_KP_End                          : constant Gdk_Key_Type := 16#FF9C#;
   GDK_KP_Begin                        : constant Gdk_Key_Type := 16#FF9D#;
   GDK_KP_Insert                       : constant Gdk_Key_Type := 16#FF9E#;
   GDK_KP_Delete                       : constant Gdk_Key_Type := 16#FF9F#;
   GDK_KP_Equal                        : constant Gdk_Key_Type := 16#FFBD#;
   GDK_KP_Multiply                     : constant Gdk_Key_Type := 16#FFAA#;
   GDK_KP_Add                          : constant Gdk_Key_Type := 16#FFAB#;
   GDK_KP_Separator                    : constant Gdk_Key_Type := 16#FFAC#;
   GDK_KP_Subtract                     : constant Gdk_Key_Type := 16#FFAD#;
   GDK_KP_Decimal                      : constant Gdk_Key_Type := 16#FFAE#;
   GDK_KP_Divide                       : constant Gdk_Key_Type := 16#FFAF#;
   GDK_KP_0                            : constant Gdk_Key_Type := 16#FFB0#;
   GDK_KP_1                            : constant Gdk_Key_Type := 16#FFB1#;
   GDK_KP_2                            : constant Gdk_Key_Type := 16#FFB2#;
   GDK_KP_3                            : constant Gdk_Key_Type := 16#FFB3#;
   GDK_KP_4                            : constant Gdk_Key_Type := 16#FFB4#;
   GDK_KP_5                            : constant Gdk_Key_Type := 16#FFB5#;
   GDK_KP_6                            : constant Gdk_Key_Type := 16#FFB6#;
   GDK_KP_7                            : constant Gdk_Key_Type := 16#FFB7#;
   GDK_KP_8                            : constant Gdk_Key_Type := 16#FFB8#;
   GDK_KP_9                            : constant Gdk_Key_Type := 16#FFB9#;
   GDK_F1                              : constant Gdk_Key_Type := 16#FFBE#;
   GDK_F2                              : constant Gdk_Key_Type := 16#FFBF#;
   GDK_F3                              : constant Gdk_Key_Type := 16#FFC0#;
   GDK_F4                              : constant Gdk_Key_Type := 16#FFC1#;
   GDK_F5                              : constant Gdk_Key_Type := 16#FFC2#;
   GDK_F6                              : constant Gdk_Key_Type := 16#FFC3#;
   GDK_F7                              : constant Gdk_Key_Type := 16#FFC4#;
   GDK_F8                              : constant Gdk_Key_Type := 16#FFC5#;
   GDK_F9                              : constant Gdk_Key_Type := 16#FFC6#;
   GDK_F10                             : constant Gdk_Key_Type := 16#FFC7#;
   GDK_F11                             : constant Gdk_Key_Type := 16#FFC8#;
   GDK_L1                              : constant Gdk_Key_Type := 16#FFC8#;
   GDK_F12                             : constant Gdk_Key_Type := 16#FFC9#;
   GDK_L2                              : constant Gdk_Key_Type := 16#FFC9#;
   GDK_F13                             : constant Gdk_Key_Type := 16#FFCA#;
   GDK_L3                              : constant Gdk_Key_Type := 16#FFCA#;
   GDK_F14                             : constant Gdk_Key_Type := 16#FFCB#;
   GDK_L4                              : constant Gdk_Key_Type := 16#FFCB#;
   GDK_F15                             : constant Gdk_Key_Type := 16#FFCC#;
   GDK_L5                              : constant Gdk_Key_Type := 16#FFCC#;
   GDK_F16                             : constant Gdk_Key_Type := 16#FFCD#;
   GDK_L6                              : constant Gdk_Key_Type := 16#FFCD#;
   GDK_F17                             : constant Gdk_Key_Type := 16#FFCE#;
   GDK_L7                              : constant Gdk_Key_Type := 16#FFCE#;
   GDK_F18                             : constant Gdk_Key_Type := 16#FFCF#;
   GDK_L8                              : constant Gdk_Key_Type := 16#FFCF#;
   GDK_F19                             : constant Gdk_Key_Type := 16#FFD0#;
   GDK_L9                              : constant Gdk_Key_Type := 16#FFD0#;
   GDK_F20                             : constant Gdk_Key_Type := 16#FFD1#;
   GDK_L10                             : constant Gdk_Key_Type := 16#FFD1#;
   GDK_F21                             : constant Gdk_Key_Type := 16#FFD2#;
   GDK_R1                              : constant Gdk_Key_Type := 16#FFD2#;
   GDK_F22                             : constant Gdk_Key_Type := 16#FFD3#;
   GDK_R2                              : constant Gdk_Key_Type := 16#FFD3#;
   GDK_F23                             : constant Gdk_Key_Type := 16#FFD4#;
   GDK_R3                              : constant Gdk_Key_Type := 16#FFD4#;
   GDK_F24                             : constant Gdk_Key_Type := 16#FFD5#;
   GDK_R4                              : constant Gdk_Key_Type := 16#FFD5#;
   GDK_F25                             : constant Gdk_Key_Type := 16#FFD6#;
   GDK_R5                              : constant Gdk_Key_Type := 16#FFD6#;
   GDK_F26                             : constant Gdk_Key_Type := 16#FFD7#;
   GDK_R6                              : constant Gdk_Key_Type := 16#FFD7#;
   GDK_F27                             : constant Gdk_Key_Type := 16#FFD8#;
   GDK_R7                              : constant Gdk_Key_Type := 16#FFD8#;
   GDK_F28                             : constant Gdk_Key_Type := 16#FFD9#;
   GDK_R8                              : constant Gdk_Key_Type := 16#FFD9#;
   GDK_F29                             : constant Gdk_Key_Type := 16#FFDA#;
   GDK_R9                              : constant Gdk_Key_Type := 16#FFDA#;
   GDK_F30                             : constant Gdk_Key_Type := 16#FFDB#;
   GDK_R10                             : constant Gdk_Key_Type := 16#FFDB#;
   GDK_F31                             : constant Gdk_Key_Type := 16#FFDC#;
   GDK_R11                             : constant Gdk_Key_Type := 16#FFDC#;
   GDK_F32                             : constant Gdk_Key_Type := 16#FFDD#;
   GDK_R12                             : constant Gdk_Key_Type := 16#FFDD#;
   GDK_F33                             : constant Gdk_Key_Type := 16#FFDE#;
   GDK_R13                             : constant Gdk_Key_Type := 16#FFDE#;
   GDK_F34                             : constant Gdk_Key_Type := 16#FFDF#;
   GDK_R14                             : constant Gdk_Key_Type := 16#FFDF#;
   GDK_F35                             : constant Gdk_Key_Type := 16#FFE0#;
   GDK_R15                             : constant Gdk_Key_Type := 16#FFE0#;
   GDK_Shift_L                         : constant Gdk_Key_Type := 16#FFE1#;
   GDK_Shift_R                         : constant Gdk_Key_Type := 16#FFE2#;
   GDK_Control_L                       : constant Gdk_Key_Type := 16#FFE3#;
   GDK_Control_R                       : constant Gdk_Key_Type := 16#FFE4#;
   GDK_Caps_Lock                       : constant Gdk_Key_Type := 16#FFE5#;
   GDK_Shift_Lock                      : constant Gdk_Key_Type := 16#FFE6#;
   GDK_Meta_L                          : constant Gdk_Key_Type := 16#FFE7#;
   GDK_Meta_R                          : constant Gdk_Key_Type := 16#FFE8#;
   GDK_Alt_L                           : constant Gdk_Key_Type := 16#FFE9#;
   GDK_Alt_R                           : constant Gdk_Key_Type := 16#FFEA#;
   GDK_Super_L                         : constant Gdk_Key_Type := 16#FFEB#;
   GDK_Super_R                         : constant Gdk_Key_Type := 16#FFEC#;
   GDK_Hyper_L                         : constant Gdk_Key_Type := 16#FFED#;
   GDK_Hyper_R                         : constant Gdk_Key_Type := 16#FFEE#;
   GDK_ISO_Lock                        : constant Gdk_Key_Type := 16#FE01#;
   GDK_ISO_Level2_Latch                : constant Gdk_Key_Type := 16#FE02#;
   GDK_ISO_Level3_Shift                : constant Gdk_Key_Type := 16#FE03#;
   GDK_ISO_Level3_Latch                : constant Gdk_Key_Type := 16#FE04#;
   GDK_ISO_Level3_Lock                 : constant Gdk_Key_Type := 16#FE05#;
   GDK_ISO_Group_Shift                 : constant Gdk_Key_Type := 16#FF7E#;
   GDK_ISO_Group_Latch                 : constant Gdk_Key_Type := 16#FE06#;
   GDK_ISO_Group_Lock                  : constant Gdk_Key_Type := 16#FE07#;
   GDK_ISO_Next_Group                  : constant Gdk_Key_Type := 16#FE08#;
   GDK_ISO_Next_Group_Lock             : constant Gdk_Key_Type := 16#FE09#;
   GDK_ISO_Prev_Group                  : constant Gdk_Key_Type := 16#FE0A#;
   GDK_ISO_Prev_Group_Lock             : constant Gdk_Key_Type := 16#FE0B#;
   GDK_ISO_First_Group                 : constant Gdk_Key_Type := 16#FE0C#;
   GDK_ISO_First_Group_Lock            : constant Gdk_Key_Type := 16#FE0D#;
   GDK_ISO_Last_Group                  : constant Gdk_Key_Type := 16#FE0E#;
   GDK_ISO_Last_Group_Lock             : constant Gdk_Key_Type := 16#FE0F#;
   GDK_ISO_Left_Tab                    : constant Gdk_Key_Type := 16#FE20#;
   GDK_ISO_Move_Line_Up                : constant Gdk_Key_Type := 16#FE21#;
   GDK_ISO_Move_Line_Down              : constant Gdk_Key_Type := 16#FE22#;
   GDK_ISO_Partial_Line_Up             : constant Gdk_Key_Type := 16#FE23#;
   GDK_ISO_Partial_Line_Down           : constant Gdk_Key_Type := 16#FE24#;
   GDK_ISO_Partial_Space_Left          : constant Gdk_Key_Type := 16#FE25#;
   GDK_ISO_Partial_Space_Right         : constant Gdk_Key_Type := 16#FE26#;
   GDK_ISO_Set_Margin_Left             : constant Gdk_Key_Type := 16#FE27#;
   GDK_ISO_Set_Margin_Right            : constant Gdk_Key_Type := 16#FE28#;
   GDK_ISO_Release_Margin_Left         : constant Gdk_Key_Type := 16#FE29#;
   GDK_ISO_Release_Margin_Right        : constant Gdk_Key_Type := 16#FE2A#;
   GDK_ISO_Release_Both_Margins        : constant Gdk_Key_Type := 16#FE2B#;
   GDK_ISO_Fast_Cursor_Left            : constant Gdk_Key_Type := 16#FE2C#;
   GDK_ISO_Fast_Cursor_Right           : constant Gdk_Key_Type := 16#FE2D#;
   GDK_ISO_Fast_Cursor_Up              : constant Gdk_Key_Type := 16#FE2E#;
   GDK_ISO_Fast_Cursor_Down            : constant Gdk_Key_Type := 16#FE2F#;
   GDK_ISO_Continuous_Underline        : constant Gdk_Key_Type := 16#FE30#;
   GDK_ISO_Discontinuous_Underline     : constant Gdk_Key_Type := 16#FE31#;
   GDK_ISO_Emphasize                   : constant Gdk_Key_Type := 16#FE32#;
   GDK_ISO_Center_Object               : constant Gdk_Key_Type := 16#FE33#;
   GDK_ISO_Enter                       : constant Gdk_Key_Type := 16#FE34#;
   GDK_Dead_Grave                      : constant Gdk_Key_Type := 16#FE50#;
   GDK_Dead_Acute                      : constant Gdk_Key_Type := 16#FE51#;
   GDK_Dead_Circumflex                 : constant Gdk_Key_Type := 16#FE52#;
   GDK_Dead_Tilde                      : constant Gdk_Key_Type := 16#FE53#;
   GDK_Dead_Macron                     : constant Gdk_Key_Type := 16#FE54#;
   GDK_Dead_Breve                      : constant Gdk_Key_Type := 16#FE55#;
   GDK_Dead_Abovedot                   : constant Gdk_Key_Type := 16#FE56#;
   GDK_Dead_Diaeresis                  : constant Gdk_Key_Type := 16#FE57#;
   GDK_Dead_Abovering                  : constant Gdk_Key_Type := 16#FE58#;
   GDK_Dead_Doubleacute                : constant Gdk_Key_Type := 16#FE59#;
   GDK_Dead_Caron                      : constant Gdk_Key_Type := 16#FE5A#;
   GDK_Dead_Cedilla                    : constant Gdk_Key_Type := 16#FE5B#;
   GDK_Dead_Ogonek                     : constant Gdk_Key_Type := 16#FE5C#;
   GDK_Dead_Iota                       : constant Gdk_Key_Type := 16#FE5D#;
   GDK_Dead_Voiced_Sound               : constant Gdk_Key_Type := 16#FE5E#;
   GDK_Dead_Semivoiced_Sound           : constant Gdk_Key_Type := 16#FE5F#;
   GDK_First_Virtual_Screen            : constant Gdk_Key_Type := 16#FED0#;
   GDK_Prev_Virtual_Screen             : constant Gdk_Key_Type := 16#FED1#;
   GDK_Next_Virtual_Screen             : constant Gdk_Key_Type := 16#FED2#;
   GDK_Last_Virtual_Screen             : constant Gdk_Key_Type := 16#FED4#;
   GDK_Terminate_Server                : constant Gdk_Key_Type := 16#FED5#;
   GDK_Pointer_Left                    : constant Gdk_Key_Type := 16#FEE0#;
   GDK_Pointer_Right                   : constant Gdk_Key_Type := 16#FEE1#;
   GDK_Pointer_Up                      : constant Gdk_Key_Type := 16#FEE2#;
   GDK_Pointer_Down                    : constant Gdk_Key_Type := 16#FEE3#;
   GDK_Pointer_UpLeft                  : constant Gdk_Key_Type := 16#FEE4#;
   GDK_Pointer_UpRight                 : constant Gdk_Key_Type := 16#FEE5#;
   GDK_Pointer_DownLeft                : constant Gdk_Key_Type := 16#FEE6#;
   GDK_Pointer_DownRight               : constant Gdk_Key_Type := 16#FEE7#;
   GDK_Pointer_Button_Dflt             : constant Gdk_Key_Type := 16#FEE8#;
   GDK_Pointer_Button1                 : constant Gdk_Key_Type := 16#FEE9#;
   GDK_Pointer_Button2                 : constant Gdk_Key_Type := 16#FEEA#;
   GDK_Pointer_Button3                 : constant Gdk_Key_Type := 16#FEEB#;
   GDK_Pointer_Button4                 : constant Gdk_Key_Type := 16#FEEC#;
   GDK_Pointer_Button5                 : constant Gdk_Key_Type := 16#FEED#;
   GDK_Pointer_DblClick_Dflt           : constant Gdk_Key_Type := 16#FEEE#;
   GDK_Pointer_DblClick1               : constant Gdk_Key_Type := 16#FEEF#;
   GDK_Pointer_DblClick2               : constant Gdk_Key_Type := 16#FEF0#;
   GDK_Pointer_DblClick3               : constant Gdk_Key_Type := 16#FEF1#;
   GDK_Pointer_DblClick4               : constant Gdk_Key_Type := 16#FEF2#;
   GDK_Pointer_DblClick5               : constant Gdk_Key_Type := 16#FEF3#;
   GDK_Pointer_Drag_Dflt               : constant Gdk_Key_Type := 16#FEF4#;
   GDK_Pointer_Drag1                   : constant Gdk_Key_Type := 16#FEF5#;
   GDK_Pointer_Drag2                   : constant Gdk_Key_Type := 16#FEF6#;
   GDK_Pointer_Drag3                   : constant Gdk_Key_Type := 16#FEF7#;
   GDK_Pointer_Drag4                   : constant Gdk_Key_Type := 16#FEF8#;
   GDK_Pointer_EnableKeys              : constant Gdk_Key_Type := 16#FEF9#;
   GDK_Pointer_Accelerate              : constant Gdk_Key_Type := 16#FEFA#;
   GDK_Pointer_DfltBtnNext             : constant Gdk_Key_Type := 16#FEFB#;
   GDK_Pointer_DfltBtnPrev             : constant Gdk_Key_Type := 16#FEFC#;
   GDK_3270_Duplicate                  : constant Gdk_Key_Type := 16#FD01#;
   GDK_3270_FieldMark                  : constant Gdk_Key_Type := 16#FD02#;
   GDK_3270_Right2                     : constant Gdk_Key_Type := 16#FD03#;
   GDK_3270_Left2                      : constant Gdk_Key_Type := 16#FD04#;
   GDK_3270_BackTab                    : constant Gdk_Key_Type := 16#FD05#;
   GDK_3270_EraseEOF                   : constant Gdk_Key_Type := 16#FD06#;
   GDK_3270_EraseInput                 : constant Gdk_Key_Type := 16#FD07#;
   GDK_3270_Reset                      : constant Gdk_Key_Type := 16#FD08#;
   GDK_3270_Quit                       : constant Gdk_Key_Type := 16#FD09#;
   GDK_3270_PA1                        : constant Gdk_Key_Type := 16#FD0A#;
   GDK_3270_PA2                        : constant Gdk_Key_Type := 16#FD0B#;
   GDK_3270_PA3                        : constant Gdk_Key_Type := 16#FD0C#;
   GDK_3270_Test                       : constant Gdk_Key_Type := 16#FD0D#;
   GDK_3270_Attn                       : constant Gdk_Key_Type := 16#FD0E#;
   GDK_3270_CursorBlink                : constant Gdk_Key_Type := 16#FD0F#;
   GDK_3270_AltCursor                  : constant Gdk_Key_Type := 16#FD10#;
   GDK_3270_KeyClick                   : constant Gdk_Key_Type := 16#FD11#;
   GDK_3270_Jump                       : constant Gdk_Key_Type := 16#FD12#;
   GDK_3270_Ident                      : constant Gdk_Key_Type := 16#FD13#;
   GDK_3270_Rule                       : constant Gdk_Key_Type := 16#FD14#;
   GDK_3270_Copy                       : constant Gdk_Key_Type := 16#FD15#;
   GDK_3270_Play                       : constant Gdk_Key_Type := 16#FD16#;
   GDK_3270_Setup                      : constant Gdk_Key_Type := 16#FD17#;
   GDK_3270_Record                     : constant Gdk_Key_Type := 16#FD18#;
   GDK_3270_ChangeScreen               : constant Gdk_Key_Type := 16#FD19#;
   GDK_3270_DeleteWord                 : constant Gdk_Key_Type := 16#FD1A#;
   GDK_3270_ExSelect                   : constant Gdk_Key_Type := 16#FD1B#;
   GDK_3270_CursorSelect               : constant Gdk_Key_Type := 16#FD1C#;
   GDK_3270_PrintScreen                : constant Gdk_Key_Type := 16#FD1D#;
   GDK_3270_Enter                      : constant Gdk_Key_Type := 16#FD1E#;
   GDK_space                           : constant Gdk_Key_Type := 16#0020#;
   GDK_exclam                          : constant Gdk_Key_Type := 16#0021#;
   GDK_quotedbl                        : constant Gdk_Key_Type := 16#0022#;
   GDK_numbersign                      : constant Gdk_Key_Type := 16#0023#;
   GDK_dollar                          : constant Gdk_Key_Type := 16#0024#;
   GDK_percent                         : constant Gdk_Key_Type := 16#0025#;
   GDK_ampersand                       : constant Gdk_Key_Type := 16#0026#;
   GDK_apostrophe                      : constant Gdk_Key_Type := 16#0027#;
   GDK_quoteright                      : constant Gdk_Key_Type := 16#0027#;
   GDK_parenleft                       : constant Gdk_Key_Type := 16#0028#;
   GDK_parenright                      : constant Gdk_Key_Type := 16#0029#;
   GDK_asterisk                        : constant Gdk_Key_Type := 16#002a#;
   GDK_plus                            : constant Gdk_Key_Type := 16#002b#;
   GDK_comma                           : constant Gdk_Key_Type := 16#002c#;
   GDK_minus                           : constant Gdk_Key_Type := 16#002d#;
   GDK_period                          : constant Gdk_Key_Type := 16#002e#;
   GDK_slash                           : constant Gdk_Key_Type := 16#002f#;
   GDK_0                               : constant Gdk_Key_Type := 16#0030#;
   GDK_1                               : constant Gdk_Key_Type := 16#0031#;
   GDK_2                               : constant Gdk_Key_Type := 16#0032#;
   GDK_3                               : constant Gdk_Key_Type := 16#0033#;
   GDK_4                               : constant Gdk_Key_Type := 16#0034#;
   GDK_5                               : constant Gdk_Key_Type := 16#0035#;
   GDK_6                               : constant Gdk_Key_Type := 16#0036#;
   GDK_7                               : constant Gdk_Key_Type := 16#0037#;
   GDK_8                               : constant Gdk_Key_Type := 16#0038#;
   GDK_9                               : constant Gdk_Key_Type := 16#0039#;
   GDK_colon                           : constant Gdk_Key_Type := 16#003a#;
   GDK_semicolon                       : constant Gdk_Key_Type := 16#003b#;
   GDK_less                            : constant Gdk_Key_Type := 16#003c#;
   GDK_equal                           : constant Gdk_Key_Type := 16#003d#;
   GDK_greater                         : constant Gdk_Key_Type := 16#003e#;
   GDK_question                        : constant Gdk_Key_Type := 16#003f#;
   GDK_at                              : constant Gdk_Key_Type := 16#0040#;
   GDK_A                               : constant Gdk_Key_Type := 16#0041#;
   GDK_B                               : constant Gdk_Key_Type := 16#0042#;
   GDK_C                               : constant Gdk_Key_Type := 16#0043#;
   GDK_D                               : constant Gdk_Key_Type := 16#0044#;
   GDK_E                               : constant Gdk_Key_Type := 16#0045#;
   GDK_F                               : constant Gdk_Key_Type := 16#0046#;
   GDK_G                               : constant Gdk_Key_Type := 16#0047#;
   GDK_H                               : constant Gdk_Key_Type := 16#0048#;
   GDK_I                               : constant Gdk_Key_Type := 16#0049#;
   GDK_J                               : constant Gdk_Key_Type := 16#004a#;
   GDK_K                               : constant Gdk_Key_Type := 16#004b#;
   GDK_L                               : constant Gdk_Key_Type := 16#004c#;
   GDK_M                               : constant Gdk_Key_Type := 16#004d#;
   GDK_N                               : constant Gdk_Key_Type := 16#004e#;
   GDK_O                               : constant Gdk_Key_Type := 16#004f#;
   GDK_P                               : constant Gdk_Key_Type := 16#0050#;
   GDK_Q                               : constant Gdk_Key_Type := 16#0051#;
   GDK_R                               : constant Gdk_Key_Type := 16#0052#;
   GDK_S                               : constant Gdk_Key_Type := 16#0053#;
   GDK_T                               : constant Gdk_Key_Type := 16#0054#;
   GDK_U                               : constant Gdk_Key_Type := 16#0055#;
   GDK_V                               : constant Gdk_Key_Type := 16#0056#;
   GDK_W                               : constant Gdk_Key_Type := 16#0057#;
   GDK_X                               : constant Gdk_Key_Type := 16#0058#;
   GDK_Y                               : constant Gdk_Key_Type := 16#0059#;
   GDK_Z                               : constant Gdk_Key_Type := 16#005a#;
   GDK_bracketleft                     : constant Gdk_Key_Type := 16#005b#;
   GDK_backslash                       : constant Gdk_Key_Type := 16#005c#;
   GDK_bracketright                    : constant Gdk_Key_Type := 16#005d#;
   GDK_asciicircum                     : constant Gdk_Key_Type := 16#005e#;
   GDK_underscore                      : constant Gdk_Key_Type := 16#005f#;
   GDK_grave                           : constant Gdk_Key_Type := 16#0060#;
   GDK_quoteleft                       : constant Gdk_Key_Type := 16#0060#;
   GDK_LC_a                            : constant Gdk_Key_Type := 16#0061#;
   GDK_LC_b                            : constant Gdk_Key_Type := 16#0062#;
   GDK_LC_c                            : constant Gdk_Key_Type := 16#0063#;
   GDK_LC_d                            : constant Gdk_Key_Type := 16#0064#;
   GDK_LC_e                            : constant Gdk_Key_Type := 16#0065#;
   GDK_LC_f                            : constant Gdk_Key_Type := 16#0066#;
   GDK_LC_g                            : constant Gdk_Key_Type := 16#0067#;
   GDK_LC_h                            : constant Gdk_Key_Type := 16#0068#;
   GDK_LC_i                            : constant Gdk_Key_Type := 16#0069#;
   GDK_LC_j                            : constant Gdk_Key_Type := 16#006a#;
   GDK_LC_k                            : constant Gdk_Key_Type := 16#006b#;
   GDK_LC_l                            : constant Gdk_Key_Type := 16#006c#;
   GDK_LC_m                            : constant Gdk_Key_Type := 16#006d#;
   GDK_LC_n                            : constant Gdk_Key_Type := 16#006e#;
   GDK_LC_o                            : constant Gdk_Key_Type := 16#006f#;
   GDK_LC_p                            : constant Gdk_Key_Type := 16#0070#;
   GDK_LC_q                            : constant Gdk_Key_Type := 16#0071#;
   GDK_LC_r                            : constant Gdk_Key_Type := 16#0072#;
   GDK_LC_s                            : constant Gdk_Key_Type := 16#0073#;
   GDK_LC_t                            : constant Gdk_Key_Type := 16#0074#;
   GDK_LC_u                            : constant Gdk_Key_Type := 16#0075#;
   GDK_LC_v                            : constant Gdk_Key_Type := 16#0076#;
   GDK_LC_w                            : constant Gdk_Key_Type := 16#0077#;
   GDK_LC_x                            : constant Gdk_Key_Type := 16#0078#;
   GDK_LC_y                            : constant Gdk_Key_Type := 16#0079#;
   GDK_LC_z                            : constant Gdk_Key_Type := 16#007a#;
   GDK_braceleft                       : constant Gdk_Key_Type := 16#007b#;
   GDK_bar                             : constant Gdk_Key_Type := 16#007c#;
   GDK_braceright                      : constant Gdk_Key_Type := 16#007d#;
   GDK_asciitilde                      : constant Gdk_Key_Type := 16#007e#;
   GDK_nobreakspace                    : constant Gdk_Key_Type := 16#00a0#;
   GDK_exclamdown                      : constant Gdk_Key_Type := 16#00a1#;
   GDK_cent                            : constant Gdk_Key_Type := 16#00a2#;
   GDK_sterling                        : constant Gdk_Key_Type := 16#00a3#;
   GDK_currency                        : constant Gdk_Key_Type := 16#00a4#;
   GDK_yen                             : constant Gdk_Key_Type := 16#00a5#;
   GDK_brokenbar                       : constant Gdk_Key_Type := 16#00a6#;
   GDK_section                         : constant Gdk_Key_Type := 16#00a7#;
   GDK_diaeresis                       : constant Gdk_Key_Type := 16#00a8#;
   GDK_copyright                       : constant Gdk_Key_Type := 16#00a9#;
   GDK_ordfeminine                     : constant Gdk_Key_Type := 16#00aa#;
   GDK_guillemotleft                   : constant Gdk_Key_Type := 16#00ab#;
   GDK_notsign                         : constant Gdk_Key_Type := 16#00ac#;
   GDK_hyphen                          : constant Gdk_Key_Type := 16#00ad#;
   GDK_registered                      : constant Gdk_Key_Type := 16#00ae#;
   GDK_macron                          : constant Gdk_Key_Type := 16#00af#;
   GDK_degree                          : constant Gdk_Key_Type := 16#00b0#;
   GDK_plusminus                       : constant Gdk_Key_Type := 16#00b1#;
   GDK_twosuperior                     : constant Gdk_Key_Type := 16#00b2#;
   GDK_threesuperior                   : constant Gdk_Key_Type := 16#00b3#;
   GDK_acute                           : constant Gdk_Key_Type := 16#00b4#;
   GDK_mu                              : constant Gdk_Key_Type := 16#00b5#;
   GDK_paragraph                       : constant Gdk_Key_Type := 16#00b6#;
   GDK_periodcentered                  : constant Gdk_Key_Type := 16#00b7#;
   GDK_cedilla                         : constant Gdk_Key_Type := 16#00b8#;
   GDK_onesuperior                     : constant Gdk_Key_Type := 16#00b9#;
   GDK_masculine                       : constant Gdk_Key_Type := 16#00ba#;
   GDK_guillemotright                  : constant Gdk_Key_Type := 16#00bb#;
   GDK_onequarter                      : constant Gdk_Key_Type := 16#00bc#;
   GDK_onehalf                         : constant Gdk_Key_Type := 16#00bd#;
   GDK_threequarters                   : constant Gdk_Key_Type := 16#00be#;
   GDK_questiondown                    : constant Gdk_Key_Type := 16#00bf#;
   GDK_Agrave                          : constant Gdk_Key_Type := 16#00c0#;
   GDK_Aacute                          : constant Gdk_Key_Type := 16#00c1#;
   GDK_Acircumflex                     : constant Gdk_Key_Type := 16#00c2#;
   GDK_Atilde                          : constant Gdk_Key_Type := 16#00c3#;
   GDK_Adiaeresis                      : constant Gdk_Key_Type := 16#00c4#;
   GDK_Aring                           : constant Gdk_Key_Type := 16#00c5#;
   GDK_AE                              : constant Gdk_Key_Type := 16#00c6#;
   GDK_Ccedilla                        : constant Gdk_Key_Type := 16#00c7#;
   GDK_Egrave                          : constant Gdk_Key_Type := 16#00c8#;
   GDK_Eacute                          : constant Gdk_Key_Type := 16#00c9#;
   GDK_Ecircumflex                     : constant Gdk_Key_Type := 16#00ca#;
   GDK_Ediaeresis                      : constant Gdk_Key_Type := 16#00cb#;
   GDK_Igrave                          : constant Gdk_Key_Type := 16#00cc#;
   GDK_Iacute                          : constant Gdk_Key_Type := 16#00cd#;
   GDK_Icircumflex                     : constant Gdk_Key_Type := 16#00ce#;
   GDK_Idiaeresis                      : constant Gdk_Key_Type := 16#00cf#;
   GDK_ETH                             : constant Gdk_Key_Type := 16#00d0#;
   GDK_Ntilde                          : constant Gdk_Key_Type := 16#00d1#;
   GDK_Ograve                          : constant Gdk_Key_Type := 16#00d2#;
   GDK_Oacute                          : constant Gdk_Key_Type := 16#00d3#;
   GDK_Ocircumflex                     : constant Gdk_Key_Type := 16#00d4#;
   GDK_Otilde                          : constant Gdk_Key_Type := 16#00d5#;
   GDK_Odiaeresis                      : constant Gdk_Key_Type := 16#00d6#;
   GDK_multiply                        : constant Gdk_Key_Type := 16#00d7#;
   GDK_Ooblique                        : constant Gdk_Key_Type := 16#00d8#;
   GDK_Ugrave                          : constant Gdk_Key_Type := 16#00d9#;
   GDK_Uacute                          : constant Gdk_Key_Type := 16#00da#;
   GDK_Ucircumflex                     : constant Gdk_Key_Type := 16#00db#;
   GDK_Udiaeresis                      : constant Gdk_Key_Type := 16#00dc#;
   GDK_Yacute                          : constant Gdk_Key_Type := 16#00dd#;
   GDK_THORN                           : constant Gdk_Key_Type := 16#00de#;
   GDK_ssharp                          : constant Gdk_Key_Type := 16#00df#;
   GDK_LC_agrave                       : constant Gdk_Key_Type := 16#00e0#;
   GDK_LC_aacute                       : constant Gdk_Key_Type := 16#00e1#;
   GDK_LC_acircumflex                  : constant Gdk_Key_Type := 16#00e2#;
   GDK_LC_atilde                       : constant Gdk_Key_Type := 16#00e3#;
   GDK_LC_adiaeresis                   : constant Gdk_Key_Type := 16#00e4#;
   GDK_LC_aring                        : constant Gdk_Key_Type := 16#00e5#;
   GDK_LC_ae                           : constant Gdk_Key_Type := 16#00e6#;
   GDK_LC_ccedilla                     : constant Gdk_Key_Type := 16#00e7#;
   GDK_LC_egrave                       : constant Gdk_Key_Type := 16#00e8#;
   GDK_LC_eacute                       : constant Gdk_Key_Type := 16#00e9#;
   GDK_LC_ecircumflex                  : constant Gdk_Key_Type := 16#00ea#;
   GDK_LC_ediaeresis                   : constant Gdk_Key_Type := 16#00eb#;
   GDK_LC_igrave                       : constant Gdk_Key_Type := 16#00ec#;
   GDK_LC_iacute                       : constant Gdk_Key_Type := 16#00ed#;
   GDK_LC_icircumflex                  : constant Gdk_Key_Type := 16#00ee#;
   GDK_LC_idiaeresis                   : constant Gdk_Key_Type := 16#00ef#;
   GDK_LC_eth                          : constant Gdk_Key_Type := 16#00f0#;
   GDK_LC_ntilde                       : constant Gdk_Key_Type := 16#00f1#;
   GDK_LC_ograve                       : constant Gdk_Key_Type := 16#00f2#;
   GDK_LC_oacute                       : constant Gdk_Key_Type := 16#00f3#;
   GDK_LC_ocircumflex                  : constant Gdk_Key_Type := 16#00f4#;
   GDK_LC_otilde                       : constant Gdk_Key_Type := 16#00f5#;
   GDK_LC_odiaeresis                   : constant Gdk_Key_Type := 16#00f6#;
   GDK_division                        : constant Gdk_Key_Type := 16#00f7#;
   GDK_oslash                          : constant Gdk_Key_Type := 16#00f8#;
   GDK_LC_ugrave                       : constant Gdk_Key_Type := 16#00f9#;
   GDK_LC_uacute                       : constant Gdk_Key_Type := 16#00fa#;
   GDK_LC_ucircumflex                  : constant Gdk_Key_Type := 16#00fb#;
   GDK_LC_udiaeresis                   : constant Gdk_Key_Type := 16#00fc#;
   GDK_LC_yacute                       : constant Gdk_Key_Type := 16#00fd#;
   GDK_LC_thorn                        : constant Gdk_Key_Type := 16#00fe#;
   GDK_ydiaeresis                      : constant Gdk_Key_Type := 16#00ff#;
   GDK_Aogonek                         : constant Gdk_Key_Type := 16#01a1#;
   GDK_breve                           : constant Gdk_Key_Type := 16#01a2#;
   GDK_Lstroke                         : constant Gdk_Key_Type := 16#01a3#;
   GDK_Lcaron                          : constant Gdk_Key_Type := 16#01a5#;
   GDK_Sacute                          : constant Gdk_Key_Type := 16#01a6#;
   GDK_Scaron                          : constant Gdk_Key_Type := 16#01a9#;
   GDK_Scedilla                        : constant Gdk_Key_Type := 16#01aa#;
   GDK_Tcaron                          : constant Gdk_Key_Type := 16#01ab#;
   GDK_Zacute                          : constant Gdk_Key_Type := 16#01ac#;
   GDK_Zcaron                          : constant Gdk_Key_Type := 16#01ae#;
   GDK_Zabovedot                       : constant Gdk_Key_Type := 16#01af#;
   GDK_LC_aogonek                      : constant Gdk_Key_Type := 16#01b1#;
   GDK_ogonek                          : constant Gdk_Key_Type := 16#01b2#;
   GDK_LC_lstroke                      : constant Gdk_Key_Type := 16#01b3#;
   GDK_LC_lcaron                       : constant Gdk_Key_Type := 16#01b5#;
   GDK_LC_sacute                       : constant Gdk_Key_Type := 16#01b6#;
   GDK_caron                           : constant Gdk_Key_Type := 16#01b7#;
   GDK_LC_scaron                       : constant Gdk_Key_Type := 16#01b9#;
   GDK_LC_scedilla                     : constant Gdk_Key_Type := 16#01ba#;
   GDK_LC_tcaron                       : constant Gdk_Key_Type := 16#01bb#;
   GDK_LC_zacute                       : constant Gdk_Key_Type := 16#01bc#;
   GDK_doubleacute                     : constant Gdk_Key_Type := 16#01bd#;
   GDK_LC_zcaron                       : constant Gdk_Key_Type := 16#01be#;
   GDK_LC_zabovedot                    : constant Gdk_Key_Type := 16#01bf#;
   GDK_Racute                          : constant Gdk_Key_Type := 16#01c0#;
   GDK_Abreve                          : constant Gdk_Key_Type := 16#01c3#;
   GDK_Lacute                          : constant Gdk_Key_Type := 16#01c5#;
   GDK_Cacute                          : constant Gdk_Key_Type := 16#01c6#;
   GDK_Ccaron                          : constant Gdk_Key_Type := 16#01c8#;
   GDK_Eogonek                         : constant Gdk_Key_Type := 16#01ca#;
   GDK_Ecaron                          : constant Gdk_Key_Type := 16#01cc#;
   GDK_Dcaron                          : constant Gdk_Key_Type := 16#01cf#;
   GDK_Dstroke                         : constant Gdk_Key_Type := 16#01d0#;
   GDK_Nacute                          : constant Gdk_Key_Type := 16#01d1#;
   GDK_Ncaron                          : constant Gdk_Key_Type := 16#01d2#;
   GDK_Odoubleacute                    : constant Gdk_Key_Type := 16#01d5#;
   GDK_Rcaron                          : constant Gdk_Key_Type := 16#01d8#;
   GDK_Uring                           : constant Gdk_Key_Type := 16#01d9#;
   GDK_Udoubleacute                    : constant Gdk_Key_Type := 16#01db#;
   GDK_Tcedilla                        : constant Gdk_Key_Type := 16#01de#;
   GDK_LC_racute                       : constant Gdk_Key_Type := 16#01e0#;
   GDK_LC_abreve                       : constant Gdk_Key_Type := 16#01e3#;
   GDK_LC_lacute                       : constant Gdk_Key_Type := 16#01e5#;
   GDK_LC_cacute                       : constant Gdk_Key_Type := 16#01e6#;
   GDK_LC_ccaron                       : constant Gdk_Key_Type := 16#01e8#;
   GDK_LC_eogonek                      : constant Gdk_Key_Type := 16#01ea#;
   GDK_LC_ecaron                       : constant Gdk_Key_Type := 16#01ec#;
   GDK_LC_dcaron                       : constant Gdk_Key_Type := 16#01ef#;
   GDK_LC_dstroke                      : constant Gdk_Key_Type := 16#01f0#;
   GDK_LC_nacute                       : constant Gdk_Key_Type := 16#01f1#;
   GDK_LC_ncaron                       : constant Gdk_Key_Type := 16#01f2#;
   GDK_LC_odoubleacute                 : constant Gdk_Key_Type := 16#01f5#;
   GDK_LC_udoubleacute                 : constant Gdk_Key_Type := 16#01fb#;
   GDK_LC_rcaron                       : constant Gdk_Key_Type := 16#01f8#;
   GDK_LC_uring                        : constant Gdk_Key_Type := 16#01f9#;
   GDK_LC_tcedilla                     : constant Gdk_Key_Type := 16#01fe#;
   GDK_abovedot                        : constant Gdk_Key_Type := 16#01ff#;
   GDK_Hstroke                         : constant Gdk_Key_Type := 16#02a1#;
   GDK_Hcircumflex                     : constant Gdk_Key_Type := 16#02a6#;
   GDK_Iabovedot                       : constant Gdk_Key_Type := 16#02a9#;
   GDK_Gbreve                          : constant Gdk_Key_Type := 16#02ab#;
   GDK_Jcircumflex                     : constant Gdk_Key_Type := 16#02ac#;
   GDK_LC_hstroke                      : constant Gdk_Key_Type := 16#02b1#;
   GDK_LC_hcircumflex                  : constant Gdk_Key_Type := 16#02b6#;
   GDK_idotless                        : constant Gdk_Key_Type := 16#02b9#;
   GDK_LC_gbreve                       : constant Gdk_Key_Type := 16#02bb#;
   GDK_LC_jcircumflex                  : constant Gdk_Key_Type := 16#02bc#;
   GDK_Cabovedot                       : constant Gdk_Key_Type := 16#02c5#;
   GDK_Ccircumflex                     : constant Gdk_Key_Type := 16#02c6#;
   GDK_Gabovedot                       : constant Gdk_Key_Type := 16#02d5#;
   GDK_Gcircumflex                     : constant Gdk_Key_Type := 16#02d8#;
   GDK_Ubreve                          : constant Gdk_Key_Type := 16#02dd#;
   GDK_Scircumflex                     : constant Gdk_Key_Type := 16#02de#;
   GDK_LC_cabovedot                    : constant Gdk_Key_Type := 16#02e5#;
   GDK_LC_ccircumflex                  : constant Gdk_Key_Type := 16#02e6#;
   GDK_LC_gabovedot                    : constant Gdk_Key_Type := 16#02f5#;
   GDK_LC_gcircumflex                  : constant Gdk_Key_Type := 16#02f8#;
   GDK_LC_ubreve                       : constant Gdk_Key_Type := 16#02fd#;
   GDK_LC_scircumflex                  : constant Gdk_Key_Type := 16#02fe#;
   GDK_kra                             : constant Gdk_Key_Type := 16#03a2#;
   GDK_kappa                           : constant Gdk_Key_Type := 16#03a2#;
   GDK_Rcedilla                        : constant Gdk_Key_Type := 16#03a3#;
   GDK_Itilde                          : constant Gdk_Key_Type := 16#03a5#;
   GDK_Lcedilla                        : constant Gdk_Key_Type := 16#03a6#;
   GDK_Emacron                         : constant Gdk_Key_Type := 16#03aa#;
   GDK_Gcedilla                        : constant Gdk_Key_Type := 16#03ab#;
   GDK_Tslash                          : constant Gdk_Key_Type := 16#03ac#;
   GDK_LC_rcedilla                     : constant Gdk_Key_Type := 16#03b3#;
   GDK_LC_itilde                       : constant Gdk_Key_Type := 16#03b5#;
   GDK_LC_lcedilla                     : constant Gdk_Key_Type := 16#03b6#;
   GDK_LC_emacron                      : constant Gdk_Key_Type := 16#03ba#;
   GDK_LC_gcedilla                     : constant Gdk_Key_Type := 16#03bb#;
   GDK_LC_tslash                       : constant Gdk_Key_Type := 16#03bc#;
   GDK_ENG                             : constant Gdk_Key_Type := 16#03bd#;
   GDK_LC_eng                          : constant Gdk_Key_Type := 16#03bf#;
   GDK_Amacron                         : constant Gdk_Key_Type := 16#03c0#;
   GDK_Iogonek                         : constant Gdk_Key_Type := 16#03c7#;
   GDK_Eabovedot                       : constant Gdk_Key_Type := 16#03cc#;
   GDK_Imacron                         : constant Gdk_Key_Type := 16#03cf#;
   GDK_Ncedilla                        : constant Gdk_Key_Type := 16#03d1#;
   GDK_Omacron                         : constant Gdk_Key_Type := 16#03d2#;
   GDK_Kcedilla                        : constant Gdk_Key_Type := 16#03d3#;
   GDK_Uogonek                         : constant Gdk_Key_Type := 16#03d9#;
   GDK_Utilde                          : constant Gdk_Key_Type := 16#03dd#;
   GDK_Umacron                         : constant Gdk_Key_Type := 16#03de#;
   GDK_LC_amacron                      : constant Gdk_Key_Type := 16#03e0#;
   GDK_LC_iogonek                      : constant Gdk_Key_Type := 16#03e7#;
   GDK_LC_eabovedot                    : constant Gdk_Key_Type := 16#03ec#;
   GDK_LC_imacron                      : constant Gdk_Key_Type := 16#03ef#;
   GDK_LC_ncedilla                     : constant Gdk_Key_Type := 16#03f1#;
   GDK_LC_omacron                      : constant Gdk_Key_Type := 16#03f2#;
   GDK_LC_kcedilla                     : constant Gdk_Key_Type := 16#03f3#;
   GDK_LC_uogonek                      : constant Gdk_Key_Type := 16#03f9#;
   GDK_LC_utilde                       : constant Gdk_Key_Type := 16#03fd#;
   GDK_LC_umacron                      : constant Gdk_Key_Type := 16#03fe#;
   GDK_overline                        : constant Gdk_Key_Type := 16#047e#;
   GDK_kana_fullstop                   : constant Gdk_Key_Type := 16#04a1#;
   GDK_kana_openingbracket             : constant Gdk_Key_Type := 16#04a2#;
   GDK_kana_closingbracket             : constant Gdk_Key_Type := 16#04a3#;
   GDK_kana_comma                      : constant Gdk_Key_Type := 16#04a4#;
   GDK_kana_conjunctive                : constant Gdk_Key_Type := 16#04a5#;
   GDK_kana_middledot                  : constant Gdk_Key_Type := 16#04a5#;
   GDK_kana_WO                         : constant Gdk_Key_Type := 16#04a6#;
   GDK_kana_LC_a                       : constant Gdk_Key_Type := 16#04a7#;
   GDK_kana_LC_i                       : constant Gdk_Key_Type := 16#04a8#;
   GDK_kana_LC_u                       : constant Gdk_Key_Type := 16#04a9#;
   GDK_kana_LC_e                       : constant Gdk_Key_Type := 16#04aa#;
   GDK_kana_LC_o                       : constant Gdk_Key_Type := 16#04ab#;
   GDK_kana_LC_ya                      : constant Gdk_Key_Type := 16#04ac#;
   GDK_kana_LC_yu                      : constant Gdk_Key_Type := 16#04ad#;
   GDK_kana_LC_yo                      : constant Gdk_Key_Type := 16#04ae#;
   GDK_kana_LC_tsu                     : constant Gdk_Key_Type := 16#04af#;
   GDK_kana_LC_tu                      : constant Gdk_Key_Type := 16#04af#;
   GDK_prolongedsound                  : constant Gdk_Key_Type := 16#04b0#;
   GDK_kana_a                          : constant Gdk_Key_Type := 16#04b1#;
   GDK_kana_i                          : constant Gdk_Key_Type := 16#04b2#;
   GDK_kana_u                          : constant Gdk_Key_Type := 16#04b3#;
   GDK_kana_e                          : constant Gdk_Key_Type := 16#04b4#;
   GDK_kana_o                          : constant Gdk_Key_Type := 16#04b5#;
   GDK_kana_KA                         : constant Gdk_Key_Type := 16#04b6#;
   GDK_kana_KI                         : constant Gdk_Key_Type := 16#04b7#;
   GDK_kana_KU                         : constant Gdk_Key_Type := 16#04b8#;
   GDK_kana_KE                         : constant Gdk_Key_Type := 16#04b9#;
   GDK_kana_KO                         : constant Gdk_Key_Type := 16#04ba#;
   GDK_kana_SA                         : constant Gdk_Key_Type := 16#04bb#;
   GDK_kana_SHI                        : constant Gdk_Key_Type := 16#04bc#;
   GDK_kana_SU                         : constant Gdk_Key_Type := 16#04bd#;
   GDK_kana_SE                         : constant Gdk_Key_Type := 16#04be#;
   GDK_kana_SO                         : constant Gdk_Key_Type := 16#04bf#;
   GDK_kana_TA                         : constant Gdk_Key_Type := 16#04c0#;
   GDK_kana_CHI                        : constant Gdk_Key_Type := 16#04c1#;
   GDK_kana_TI                         : constant Gdk_Key_Type := 16#04c1#;
   GDK_kana_tsu                        : constant Gdk_Key_Type := 16#04c2#;
   GDK_kana_tu                         : constant Gdk_Key_Type := 16#04c2#;
   GDK_kana_TE                         : constant Gdk_Key_Type := 16#04c3#;
   GDK_kana_TO                         : constant Gdk_Key_Type := 16#04c4#;
   GDK_kana_NA                         : constant Gdk_Key_Type := 16#04c5#;
   GDK_kana_NI                         : constant Gdk_Key_Type := 16#04c6#;
   GDK_kana_NU                         : constant Gdk_Key_Type := 16#04c7#;
   GDK_kana_NE                         : constant Gdk_Key_Type := 16#04c8#;
   GDK_kana_NO                         : constant Gdk_Key_Type := 16#04c9#;
   GDK_kana_HA                         : constant Gdk_Key_Type := 16#04ca#;
   GDK_kana_HI                         : constant Gdk_Key_Type := 16#04cb#;
   GDK_kana_FU                         : constant Gdk_Key_Type := 16#04cc#;
   GDK_kana_HU                         : constant Gdk_Key_Type := 16#04cc#;
   GDK_kana_HE                         : constant Gdk_Key_Type := 16#04cd#;
   GDK_kana_HO                         : constant Gdk_Key_Type := 16#04ce#;
   GDK_kana_MA                         : constant Gdk_Key_Type := 16#04cf#;
   GDK_kana_MI                         : constant Gdk_Key_Type := 16#04d0#;
   GDK_kana_MU                         : constant Gdk_Key_Type := 16#04d1#;
   GDK_kana_ME                         : constant Gdk_Key_Type := 16#04d2#;
   GDK_kana_MO                         : constant Gdk_Key_Type := 16#04d3#;
   GDK_kana_ya                         : constant Gdk_Key_Type := 16#04d4#;
   GDK_kana_yu                         : constant Gdk_Key_Type := 16#04d5#;
   GDK_kana_yo                         : constant Gdk_Key_Type := 16#04d6#;
   GDK_kana_RA                         : constant Gdk_Key_Type := 16#04d7#;
   GDK_kana_RI                         : constant Gdk_Key_Type := 16#04d8#;
   GDK_kana_RU                         : constant Gdk_Key_Type := 16#04d9#;
   GDK_kana_RE                         : constant Gdk_Key_Type := 16#04da#;
   GDK_kana_RO                         : constant Gdk_Key_Type := 16#04db#;
   GDK_kana_WA                         : constant Gdk_Key_Type := 16#04dc#;
   GDK_kana_N                          : constant Gdk_Key_Type := 16#04dd#;
   GDK_voicedsound                     : constant Gdk_Key_Type := 16#04de#;
   GDK_semivoicedsound                 : constant Gdk_Key_Type := 16#04df#;
   GDK_kana_switch                     : constant Gdk_Key_Type := 16#FF7E#;
   GDK_Arabic_comma                    : constant Gdk_Key_Type := 16#05ac#;
   GDK_Arabic_semicolon                : constant Gdk_Key_Type := 16#05bb#;
   GDK_Arabic_Question_Mark            : constant Gdk_Key_Type := 16#05bf#;
   GDK_Arabic_hamza                    : constant Gdk_Key_Type := 16#05c1#;
   GDK_Arabic_maddaonalef              : constant Gdk_Key_Type := 16#05c2#;
   GDK_Arabic_hamzaonalef              : constant Gdk_Key_Type := 16#05c3#;
   GDK_Arabic_hamzaonwaw               : constant Gdk_Key_Type := 16#05c4#;
   GDK_Arabic_hamzaunderalef           : constant Gdk_Key_Type := 16#05c5#;
   GDK_Arabic_hamzaonyeh               : constant Gdk_Key_Type := 16#05c6#;
   GDK_Arabic_alef                     : constant Gdk_Key_Type := 16#05c7#;
   GDK_Arabic_beh                      : constant Gdk_Key_Type := 16#05c8#;
   GDK_Arabic_tehmarbuta               : constant Gdk_Key_Type := 16#05c9#;
   GDK_Arabic_teh                      : constant Gdk_Key_Type := 16#05ca#;
   GDK_Arabic_theh                     : constant Gdk_Key_Type := 16#05cb#;
   GDK_Arabic_jeem                     : constant Gdk_Key_Type := 16#05cc#;
   GDK_Arabic_hah                      : constant Gdk_Key_Type := 16#05cd#;
   GDK_Arabic_khah                     : constant Gdk_Key_Type := 16#05ce#;
   GDK_Arabic_dal                      : constant Gdk_Key_Type := 16#05cf#;
   GDK_Arabic_thal                     : constant Gdk_Key_Type := 16#05d0#;
   GDK_Arabic_ra                       : constant Gdk_Key_Type := 16#05d1#;
   GDK_Arabic_zain                     : constant Gdk_Key_Type := 16#05d2#;
   GDK_Arabic_seen                     : constant Gdk_Key_Type := 16#05d3#;
   GDK_Arabic_sheen                    : constant Gdk_Key_Type := 16#05d4#;
   GDK_Arabic_sad                      : constant Gdk_Key_Type := 16#05d5#;
   GDK_Arabic_dad                      : constant Gdk_Key_Type := 16#05d6#;
   GDK_Arabic_tah                      : constant Gdk_Key_Type := 16#05d7#;
   GDK_Arabic_zah                      : constant Gdk_Key_Type := 16#05d8#;
   GDK_Arabic_ain                      : constant Gdk_Key_Type := 16#05d9#;
   GDK_Arabic_ghain                    : constant Gdk_Key_Type := 16#05da#;
   GDK_Arabic_tatweel                  : constant Gdk_Key_Type := 16#05e0#;
   GDK_Arabic_feh                      : constant Gdk_Key_Type := 16#05e1#;
   GDK_Arabic_qaf                      : constant Gdk_Key_Type := 16#05e2#;
   GDK_Arabic_kaf                      : constant Gdk_Key_Type := 16#05e3#;
   GDK_Arabic_lam                      : constant Gdk_Key_Type := 16#05e4#;
   GDK_Arabic_meem                     : constant Gdk_Key_Type := 16#05e5#;
   GDK_Arabic_noon                     : constant Gdk_Key_Type := 16#05e6#;
   GDK_Arabic_ha                       : constant Gdk_Key_Type := 16#05e7#;
   GDK_Arabic_heh                      : constant Gdk_Key_Type := 16#05e7#;
   GDK_Arabic_waw                      : constant Gdk_Key_Type := 16#05e8#;
   GDK_Arabic_alefmaksura              : constant Gdk_Key_Type := 16#05e9#;
   GDK_Arabic_yeh                      : constant Gdk_Key_Type := 16#05ea#;
   GDK_Arabic_fathatan                 : constant Gdk_Key_Type := 16#05eb#;
   GDK_Arabic_dammatan                 : constant Gdk_Key_Type := 16#05ec#;
   GDK_Arabic_kasratan                 : constant Gdk_Key_Type := 16#05ed#;
   GDK_Arabic_fatha                    : constant Gdk_Key_Type := 16#05ee#;
   GDK_Arabic_damma                    : constant Gdk_Key_Type := 16#05ef#;
   GDK_Arabic_kasra                    : constant Gdk_Key_Type := 16#05f0#;
   GDK_Arabic_shadda                   : constant Gdk_Key_Type := 16#05f1#;
   GDK_Arabic_sukun                    : constant Gdk_Key_Type := 16#05f2#;
   GDK_Arabic_switch                   : constant Gdk_Key_Type := 16#FF7E#;
   GDK_Serbian_LC_dje                  : constant Gdk_Key_Type := 16#06a1#;
   GDK_Macedonia_LC_gje                : constant Gdk_Key_Type := 16#06a2#;
   GDK_Cyrillic_LC_io                  : constant Gdk_Key_Type := 16#06a3#;
   GDK_Ukrainian_LC_ie                 : constant Gdk_Key_Type := 16#06a4#;
   GDK_Ukranian_LC_je                  : constant Gdk_Key_Type := 16#06a4#;
   GDK_Macedonia_LC_dse                : constant Gdk_Key_Type := 16#06a5#;
   GDK_Ukrainian_LC_i                  : constant Gdk_Key_Type := 16#06a6#;
   GDK_Ukranian_LC_i                   : constant Gdk_Key_Type := 16#06a6#;
   GDK_Ukrainian_LC_yi                 : constant Gdk_Key_Type := 16#06a7#;
   GDK_Ukranian_LC_yi                  : constant Gdk_Key_Type := 16#06a7#;
   GDK_Cyrillic_LC_je                  : constant Gdk_Key_Type := 16#06a8#;
   GDK_Serbian_LC_je                   : constant Gdk_Key_Type := 16#06a8#;
   GDK_Cyrillic_LC_lje                 : constant Gdk_Key_Type := 16#06a9#;
   GDK_Serbian_LC_lje                  : constant Gdk_Key_Type := 16#06a9#;
   GDK_Cyrillic_LC_nje                 : constant Gdk_Key_Type := 16#06aa#;
   GDK_Serbian_LC_nje                  : constant Gdk_Key_Type := 16#06aa#;
   GDK_Serbian_LC_tshe                 : constant Gdk_Key_Type := 16#06ab#;
   GDK_Macedonia_LC_kje                : constant Gdk_Key_Type := 16#06ac#;
   GDK_Byelorussian_LC_shortu          : constant Gdk_Key_Type := 16#06ae#;
   GDK_Cyrillic_LC_dzhe                : constant Gdk_Key_Type := 16#06af#;
   GDK_Serbian_LC_dze                  : constant Gdk_Key_Type := 16#06af#;
   GDK_numerosign                      : constant Gdk_Key_Type := 16#06b0#;
   GDK_Serbian_dje                     : constant Gdk_Key_Type := 16#06b1#;
   GDK_Macedonia_gje                   : constant Gdk_Key_Type := 16#06b2#;
   GDK_Cyrillic_io                     : constant Gdk_Key_Type := 16#06b3#;
   GDK_Ukrainian_ie                    : constant Gdk_Key_Type := 16#06b4#;
   GDK_Ukranian_je                     : constant Gdk_Key_Type := 16#06b4#;
   GDK_Macedonia_dse                   : constant Gdk_Key_Type := 16#06b5#;
   GDK_Ukrainian_i                     : constant Gdk_Key_Type := 16#06b6#;
   GDK_Ukranian_i                      : constant Gdk_Key_Type := 16#06b6#;
   GDK_Ukrainian_yi                    : constant Gdk_Key_Type := 16#06b7#;
   GDK_Ukranian_yi                     : constant Gdk_Key_Type := 16#06b7#;
   GDK_Cyrillic_je                     : constant Gdk_Key_Type := 16#06b8#;
   GDK_Serbian_je                      : constant Gdk_Key_Type := 16#06b8#;
   GDK_Cyrillic_lje                    : constant Gdk_Key_Type := 16#06b9#;
   GDK_Serbian_lje                     : constant Gdk_Key_Type := 16#06b9#;
   GDK_Cyrillic_nje                    : constant Gdk_Key_Type := 16#06ba#;
   GDK_Serbian_nje                     : constant Gdk_Key_Type := 16#06ba#;
   GDK_Serbian_tshe                    : constant Gdk_Key_Type := 16#06bb#;
   GDK_Macedonia_kje                   : constant Gdk_Key_Type := 16#06bc#;
   GDK_Byelorussian_shortu             : constant Gdk_Key_Type := 16#06be#;
   GDK_Cyrillic_dzhe                   : constant Gdk_Key_Type := 16#06bf#;
   GDK_Serbian_dze                     : constant Gdk_Key_Type := 16#06bf#;
   GDK_Cyrillic_LC_yu                  : constant Gdk_Key_Type := 16#06c0#;
   GDK_Cyrillic_LC_a                   : constant Gdk_Key_Type := 16#06c1#;
   GDK_Cyrillic_LC_be                  : constant Gdk_Key_Type := 16#06c2#;
   GDK_Cyrillic_LC_tse                 : constant Gdk_Key_Type := 16#06c3#;
   GDK_Cyrillic_LC_de                  : constant Gdk_Key_Type := 16#06c4#;
   GDK_Cyrillic_LC_ie                  : constant Gdk_Key_Type := 16#06c5#;
   GDK_Cyrillic_LC_ef                  : constant Gdk_Key_Type := 16#06c6#;
   GDK_Cyrillic_LC_ghe                 : constant Gdk_Key_Type := 16#06c7#;
   GDK_Cyrillic_LC_ha                  : constant Gdk_Key_Type := 16#06c8#;
   GDK_Cyrillic_LC_i                   : constant Gdk_Key_Type := 16#06c9#;
   GDK_Cyrillic_LC_shorti              : constant Gdk_Key_Type := 16#06ca#;
   GDK_Cyrillic_LC_ka                  : constant Gdk_Key_Type := 16#06cb#;
   GDK_Cyrillic_LC_el                  : constant Gdk_Key_Type := 16#06cc#;
   GDK_Cyrillic_LC_em                  : constant Gdk_Key_Type := 16#06cd#;
   GDK_Cyrillic_LC_en                  : constant Gdk_Key_Type := 16#06ce#;
   GDK_Cyrillic_LC_o                   : constant Gdk_Key_Type := 16#06cf#;
   GDK_Cyrillic_LC_pe                  : constant Gdk_Key_Type := 16#06d0#;
   GDK_Cyrillic_LC_ya                  : constant Gdk_Key_Type := 16#06d1#;
   GDK_Cyrillic_LC_er                  : constant Gdk_Key_Type := 16#06d2#;
   GDK_Cyrillic_LC_es                  : constant Gdk_Key_Type := 16#06d3#;
   GDK_Cyrillic_LC_te                  : constant Gdk_Key_Type := 16#06d4#;
   GDK_Cyrillic_LC_u                   : constant Gdk_Key_Type := 16#06d5#;
   GDK_Cyrillic_LC_zhe                 : constant Gdk_Key_Type := 16#06d6#;
   GDK_Cyrillic_LC_ve                  : constant Gdk_Key_Type := 16#06d7#;
   GDK_Cyrillic_LC_softsign            : constant Gdk_Key_Type := 16#06d8#;
   GDK_Cyrillic_LC_yeru                : constant Gdk_Key_Type := 16#06d9#;
   GDK_Cyrillic_LC_ze                  : constant Gdk_Key_Type := 16#06da#;
   GDK_Cyrillic_LC_sha                 : constant Gdk_Key_Type := 16#06db#;
   GDK_Cyrillic_LC_e                   : constant Gdk_Key_Type := 16#06dc#;
   GDK_Cyrillic_LC_shcha               : constant Gdk_Key_Type := 16#06dd#;
   GDK_Cyrillic_LC_che                 : constant Gdk_Key_Type := 16#06de#;
   GDK_Cyrillic_LC_hardsign            : constant Gdk_Key_Type := 16#06df#;
   GDK_Cyrillic_yu                     : constant Gdk_Key_Type := 16#06e0#;
   GDK_Cyrillic_a                      : constant Gdk_Key_Type := 16#06e1#;
   GDK_Cyrillic_be                     : constant Gdk_Key_Type := 16#06e2#;
   GDK_Cyrillic_tse                    : constant Gdk_Key_Type := 16#06e3#;
   GDK_Cyrillic_de                     : constant Gdk_Key_Type := 16#06e4#;
   GDK_Cyrillic_ie                     : constant Gdk_Key_Type := 16#06e5#;
   GDK_Cyrillic_ef                     : constant Gdk_Key_Type := 16#06e6#;
   GDK_Cyrillic_ghe                    : constant Gdk_Key_Type := 16#06e7#;
   GDK_Cyrillic_ha                     : constant Gdk_Key_Type := 16#06e8#;
   GDK_Cyrillic_i                      : constant Gdk_Key_Type := 16#06e9#;
   GDK_Cyrillic_shorti                 : constant Gdk_Key_Type := 16#06ea#;
   GDK_Cyrillic_ka                     : constant Gdk_Key_Type := 16#06eb#;
   GDK_Cyrillic_el                     : constant Gdk_Key_Type := 16#06ec#;
   GDK_Cyrillic_em                     : constant Gdk_Key_Type := 16#06ed#;
   GDK_Cyrillic_en                     : constant Gdk_Key_Type := 16#06ee#;
   GDK_Cyrillic_o                      : constant Gdk_Key_Type := 16#06ef#;
   GDK_Cyrillic_pe                     : constant Gdk_Key_Type := 16#06f0#;
   GDK_Cyrillic_ya                     : constant Gdk_Key_Type := 16#06f1#;
   GDK_Cyrillic_er                     : constant Gdk_Key_Type := 16#06f2#;
   GDK_Cyrillic_es                     : constant Gdk_Key_Type := 16#06f3#;
   GDK_Cyrillic_te                     : constant Gdk_Key_Type := 16#06f4#;
   GDK_Cyrillic_u                      : constant Gdk_Key_Type := 16#06f5#;
   GDK_Cyrillic_zhe                    : constant Gdk_Key_Type := 16#06f6#;
   GDK_Cyrillic_ve                     : constant Gdk_Key_Type := 16#06f7#;
   GDK_Cyrillic_softsign               : constant Gdk_Key_Type := 16#06f8#;
   GDK_Cyrillic_yeru                   : constant Gdk_Key_Type := 16#06f9#;
   GDK_Cyrillic_ze                     : constant Gdk_Key_Type := 16#06fa#;
   GDK_Cyrillic_sha                    : constant Gdk_Key_Type := 16#06fb#;
   GDK_Cyrillic_e                      : constant Gdk_Key_Type := 16#06fc#;
   GDK_Cyrillic_shcha                  : constant Gdk_Key_Type := 16#06fd#;
   GDK_Cyrillic_che                    : constant Gdk_Key_Type := 16#06fe#;
   GDK_Cyrillic_hardsign               : constant Gdk_Key_Type := 16#06ff#;
   GDK_Greek_ALPHAaccent               : constant Gdk_Key_Type := 16#07a1#;
   GDK_Greek_EPSILONaccent             : constant Gdk_Key_Type := 16#07a2#;
   GDK_Greek_ETAaccent                 : constant Gdk_Key_Type := 16#07a3#;
   GDK_Greek_IOTAaccent                : constant Gdk_Key_Type := 16#07a4#;
   GDK_Greek_IOTAdiaeresis             : constant Gdk_Key_Type := 16#07a5#;
   GDK_Greek_OMICRONaccent             : constant Gdk_Key_Type := 16#07a7#;
   GDK_Greek_UPSILONaccent             : constant Gdk_Key_Type := 16#07a8#;
   GDK_Greek_UPSILONdieresis           : constant Gdk_Key_Type := 16#07a9#;
   GDK_Greek_OMEGAaccent               : constant Gdk_Key_Type := 16#07ab#;
   GDK_Greek_accentdieresis            : constant Gdk_Key_Type := 16#07ae#;
   GDK_Greek_horizbar                  : constant Gdk_Key_Type := 16#07af#;
   GDK_Greek_LC_alphaaccent            : constant Gdk_Key_Type := 16#07b1#;
   GDK_Greek_LC_epsilonaccent          : constant Gdk_Key_Type := 16#07b2#;
   GDK_Greek_LC_etaaccent              : constant Gdk_Key_Type := 16#07b3#;
   GDK_Greek_LC_iotaaccent             : constant Gdk_Key_Type := 16#07b4#;
   GDK_Greek_iotadieresis              : constant Gdk_Key_Type := 16#07b5#;
   GDK_Greek_iotaaccentdieresis        : constant Gdk_Key_Type := 16#07b6#;
   GDK_Greek_LC_omicronaccent          : constant Gdk_Key_Type := 16#07b7#;
   GDK_Greek_LC_upsilonaccent          : constant Gdk_Key_Type := 16#07b8#;
   GDK_Greek_LC_upsilondieresis        : constant Gdk_Key_Type := 16#07b9#;
   GDK_Greek_upsilonaccentdieresis     : constant Gdk_Key_Type := 16#07ba#;
   GDK_Greek_LC_omegaaccent            : constant Gdk_Key_Type := 16#07bb#;
   GDK_Greek_ALPHA                     : constant Gdk_Key_Type := 16#07c1#;
   GDK_Greek_BETA                      : constant Gdk_Key_Type := 16#07c2#;
   GDK_Greek_GAMMA                     : constant Gdk_Key_Type := 16#07c3#;
   GDK_Greek_DELTA                     : constant Gdk_Key_Type := 16#07c4#;
   GDK_Greek_EPSILON                   : constant Gdk_Key_Type := 16#07c5#;
   GDK_Greek_ZETA                      : constant Gdk_Key_Type := 16#07c6#;
   GDK_Greek_ETA                       : constant Gdk_Key_Type := 16#07c7#;
   GDK_Greek_THETA                     : constant Gdk_Key_Type := 16#07c8#;
   GDK_Greek_IOTA                      : constant Gdk_Key_Type := 16#07c9#;
   GDK_Greek_KAPPA                     : constant Gdk_Key_Type := 16#07ca#;
   GDK_Greek_LAMDA                     : constant Gdk_Key_Type := 16#07cb#;
   GDK_Greek_LAMBDA                    : constant Gdk_Key_Type := 16#07cb#;
   GDK_Greek_MU                        : constant Gdk_Key_Type := 16#07cc#;
   GDK_Greek_NU                        : constant Gdk_Key_Type := 16#07cd#;
   GDK_Greek_XI                        : constant Gdk_Key_Type := 16#07ce#;
   GDK_Greek_OMICRON                   : constant Gdk_Key_Type := 16#07cf#;
   GDK_Greek_PI                        : constant Gdk_Key_Type := 16#07d0#;
   GDK_Greek_RHO                       : constant Gdk_Key_Type := 16#07d1#;
   GDK_Greek_SIGMA                     : constant Gdk_Key_Type := 16#07d2#;
   GDK_Greek_TAU                       : constant Gdk_Key_Type := 16#07d4#;
   GDK_Greek_UPSILON                   : constant Gdk_Key_Type := 16#07d5#;
   GDK_Greek_PHI                       : constant Gdk_Key_Type := 16#07d6#;
   GDK_Greek_CHI                       : constant Gdk_Key_Type := 16#07d7#;
   GDK_Greek_PSI                       : constant Gdk_Key_Type := 16#07d8#;
   GDK_Greek_OMEGA                     : constant Gdk_Key_Type := 16#07d9#;
   GDK_Greek_LC_alpha                  : constant Gdk_Key_Type := 16#07e1#;
   GDK_Greek_LC_beta                   : constant Gdk_Key_Type := 16#07e2#;
   GDK_Greek_LC_gamma                  : constant Gdk_Key_Type := 16#07e3#;
   GDK_Greek_LC_delta                  : constant Gdk_Key_Type := 16#07e4#;
   GDK_Greek_LC_epsilon                : constant Gdk_Key_Type := 16#07e5#;
   GDK_Greek_LC_zeta                   : constant Gdk_Key_Type := 16#07e6#;
   GDK_Greek_LC_eta                    : constant Gdk_Key_Type := 16#07e7#;
   GDK_Greek_LC_theta                  : constant Gdk_Key_Type := 16#07e8#;
   GDK_Greek_LC_iota                   : constant Gdk_Key_Type := 16#07e9#;
   GDK_Greek_LC_kappa                  : constant Gdk_Key_Type := 16#07ea#;
   GDK_Greek_LC_lamda                  : constant Gdk_Key_Type := 16#07eb#;
   GDK_Greek_LC_lambda                 : constant Gdk_Key_Type := 16#07eb#;
   GDK_Greek_LC_mu                     : constant Gdk_Key_Type := 16#07ec#;
   GDK_Greek_LC_nu                     : constant Gdk_Key_Type := 16#07ed#;
   GDK_Greek_LC_xi                     : constant Gdk_Key_Type := 16#07ee#;
   GDK_Greek_LC_omicron                : constant Gdk_Key_Type := 16#07ef#;
   GDK_Greek_LC_pi                     : constant Gdk_Key_Type := 16#07f0#;
   GDK_Greek_LC_rho                    : constant Gdk_Key_Type := 16#07f1#;
   GDK_Greek_LC_sigma                  : constant Gdk_Key_Type := 16#07f2#;
   GDK_Greek_finalsmallsigma           : constant Gdk_Key_Type := 16#07f3#;
   GDK_Greek_LC_tau                    : constant Gdk_Key_Type := 16#07f4#;
   GDK_Greek_LC_upsilon                : constant Gdk_Key_Type := 16#07f5#;
   GDK_Greek_LC_phi                    : constant Gdk_Key_Type := 16#07f6#;
   GDK_Greek_LC_chi                    : constant Gdk_Key_Type := 16#07f7#;
   GDK_Greek_LC_psi                    : constant Gdk_Key_Type := 16#07f8#;
   GDK_Greek_LC_omega                  : constant Gdk_Key_Type := 16#07f9#;
   GDK_Greek_switch                    : constant Gdk_Key_Type := 16#FF7E#;
   GDK_leftradical                     : constant Gdk_Key_Type := 16#08a1#;
   GDK_topleftradical                  : constant Gdk_Key_Type := 16#08a2#;
   GDK_horizconnector                  : constant Gdk_Key_Type := 16#08a3#;
   GDK_topintegral                     : constant Gdk_Key_Type := 16#08a4#;
   GDK_botintegral                     : constant Gdk_Key_Type := 16#08a5#;
   GDK_vertconnector                   : constant Gdk_Key_Type := 16#08a6#;
   GDK_topleftsqbracket                : constant Gdk_Key_Type := 16#08a7#;
   GDK_botleftsqbracket                : constant Gdk_Key_Type := 16#08a8#;
   GDK_toprightsqbracket               : constant Gdk_Key_Type := 16#08a9#;
   GDK_botrightsqbracket               : constant Gdk_Key_Type := 16#08aa#;
   GDK_topleftparens                   : constant Gdk_Key_Type := 16#08ab#;
   GDK_botleftparens                   : constant Gdk_Key_Type := 16#08ac#;
   GDK_toprightparens                  : constant Gdk_Key_Type := 16#08ad#;
   GDK_botrightparens                  : constant Gdk_Key_Type := 16#08ae#;
   GDK_leftmiddlecurlybrace            : constant Gdk_Key_Type := 16#08af#;
   GDK_rightmiddlecurlybrace           : constant Gdk_Key_Type := 16#08b0#;
   GDK_topleftsummation                : constant Gdk_Key_Type := 16#08b1#;
   GDK_botleftsummation                : constant Gdk_Key_Type := 16#08b2#;
   GDK_topvertsummationconnector       : constant Gdk_Key_Type := 16#08b3#;
   GDK_botvertsummationconnector       : constant Gdk_Key_Type := 16#08b4#;
   GDK_toprightsummation               : constant Gdk_Key_Type := 16#08b5#;
   GDK_botrightsummation               : constant Gdk_Key_Type := 16#08b6#;
   GDK_rightmiddlesummation            : constant Gdk_Key_Type := 16#08b7#;
   GDK_lessthanequal                   : constant Gdk_Key_Type := 16#08bc#;
   GDK_notequal                        : constant Gdk_Key_Type := 16#08bd#;
   GDK_greaterthanequal                : constant Gdk_Key_Type := 16#08be#;
   GDK_integral                        : constant Gdk_Key_Type := 16#08bf#;
   GDK_therefore                       : constant Gdk_Key_Type := 16#08c0#;
   GDK_variation                       : constant Gdk_Key_Type := 16#08c1#;
   GDK_infinity                        : constant Gdk_Key_Type := 16#08c2#;
   GDK_nabla                           : constant Gdk_Key_Type := 16#08c5#;
   GDK_approximate                     : constant Gdk_Key_Type := 16#08c8#;
   GDK_similarequal                    : constant Gdk_Key_Type := 16#08c9#;
   GDK_ifonlyif                        : constant Gdk_Key_Type := 16#08cd#;
   GDK_implies                         : constant Gdk_Key_Type := 16#08ce#;
   GDK_identical                       : constant Gdk_Key_Type := 16#08cf#;
   GDK_radical                         : constant Gdk_Key_Type := 16#08d6#;
   GDK_includedin                      : constant Gdk_Key_Type := 16#08da#;
   GDK_includes                        : constant Gdk_Key_Type := 16#08db#;
   GDK_intersection                    : constant Gdk_Key_Type := 16#08dc#;
   GDK_union                           : constant Gdk_Key_Type := 16#08dd#;
   GDK_logicaland                      : constant Gdk_Key_Type := 16#08de#;
   GDK_logicalor                       : constant Gdk_Key_Type := 16#08df#;
   GDK_partialderivative               : constant Gdk_Key_Type := 16#08ef#;
   GDK_function                        : constant Gdk_Key_Type := 16#08f6#;
   GDK_leftarrow                       : constant Gdk_Key_Type := 16#08fb#;
   GDK_uparrow                         : constant Gdk_Key_Type := 16#08fc#;
   GDK_rightarrow                      : constant Gdk_Key_Type := 16#08fd#;
   GDK_downarrow                       : constant Gdk_Key_Type := 16#08fe#;
   GDK_blank                           : constant Gdk_Key_Type := 16#09df#;
   GDK_soliddiamond                    : constant Gdk_Key_Type := 16#09e0#;
   GDK_checkerboard                    : constant Gdk_Key_Type := 16#09e1#;
   GDK_ht                              : constant Gdk_Key_Type := 16#09e2#;
   GDK_ff                              : constant Gdk_Key_Type := 16#09e3#;
   GDK_cr                              : constant Gdk_Key_Type := 16#09e4#;
   GDK_lf                              : constant Gdk_Key_Type := 16#09e5#;
   GDK_nl                              : constant Gdk_Key_Type := 16#09e8#;
   GDK_vt                              : constant Gdk_Key_Type := 16#09e9#;
   GDK_lowrightcorner                  : constant Gdk_Key_Type := 16#09ea#;
   GDK_uprightcorner                   : constant Gdk_Key_Type := 16#09eb#;
   GDK_upleftcorner                    : constant Gdk_Key_Type := 16#09ec#;
   GDK_lowleftcorner                   : constant Gdk_Key_Type := 16#09ed#;
   GDK_crossinglines                   : constant Gdk_Key_Type := 16#09ee#;
   GDK_horizlinescan1                  : constant Gdk_Key_Type := 16#09ef#;
   GDK_horizlinescan3                  : constant Gdk_Key_Type := 16#09f0#;
   GDK_horizlinescan5                  : constant Gdk_Key_Type := 16#09f1#;
   GDK_horizlinescan7                  : constant Gdk_Key_Type := 16#09f2#;
   GDK_horizlinescan9                  : constant Gdk_Key_Type := 16#09f3#;
   GDK_leftt                           : constant Gdk_Key_Type := 16#09f4#;
   GDK_rightt                          : constant Gdk_Key_Type := 16#09f5#;
   GDK_bott                            : constant Gdk_Key_Type := 16#09f6#;
   GDK_topt                            : constant Gdk_Key_Type := 16#09f7#;
   GDK_vertbar                         : constant Gdk_Key_Type := 16#09f8#;
   GDK_emspace                         : constant Gdk_Key_Type := 16#0aa1#;
   GDK_enspace                         : constant Gdk_Key_Type := 16#0aa2#;
   GDK_em3space                        : constant Gdk_Key_Type := 16#0aa3#;
   GDK_em4space                        : constant Gdk_Key_Type := 16#0aa4#;
   GDK_digitspace                      : constant Gdk_Key_Type := 16#0aa5#;
   GDK_punctspace                      : constant Gdk_Key_Type := 16#0aa6#;
   GDK_thinspace                       : constant Gdk_Key_Type := 16#0aa7#;
   GDK_hairspace                       : constant Gdk_Key_Type := 16#0aa8#;
   GDK_emdash                          : constant Gdk_Key_Type := 16#0aa9#;
   GDK_endash                          : constant Gdk_Key_Type := 16#0aaa#;
   GDK_signifblank                     : constant Gdk_Key_Type := 16#0aac#;
   GDK_ellipsis                        : constant Gdk_Key_Type := 16#0aae#;
   GDK_doubbaselinedot                 : constant Gdk_Key_Type := 16#0aaf#;
   GDK_onethird                        : constant Gdk_Key_Type := 16#0ab0#;
   GDK_twothirds                       : constant Gdk_Key_Type := 16#0ab1#;
   GDK_onefifth                        : constant Gdk_Key_Type := 16#0ab2#;
   GDK_twofifths                       : constant Gdk_Key_Type := 16#0ab3#;
   GDK_threefifths                     : constant Gdk_Key_Type := 16#0ab4#;
   GDK_fourfifths                      : constant Gdk_Key_Type := 16#0ab5#;
   GDK_onesixth                        : constant Gdk_Key_Type := 16#0ab6#;
   GDK_fivesixths                      : constant Gdk_Key_Type := 16#0ab7#;
   GDK_careof                          : constant Gdk_Key_Type := 16#0ab8#;
   GDK_figdash                         : constant Gdk_Key_Type := 16#0abb#;
   GDK_leftanglebracket                : constant Gdk_Key_Type := 16#0abc#;
   GDK_decimalpoint                    : constant Gdk_Key_Type := 16#0abd#;
   GDK_rightanglebracket               : constant Gdk_Key_Type := 16#0abe#;
   GDK_marker                          : constant Gdk_Key_Type := 16#0abf#;
   GDK_oneeighth                       : constant Gdk_Key_Type := 16#0ac3#;
   GDK_threeeighths                    : constant Gdk_Key_Type := 16#0ac4#;
   GDK_fiveeighths                     : constant Gdk_Key_Type := 16#0ac5#;
   GDK_seveneighths                    : constant Gdk_Key_Type := 16#0ac6#;
   GDK_trademark                       : constant Gdk_Key_Type := 16#0ac9#;
   GDK_signaturemark                   : constant Gdk_Key_Type := 16#0aca#;
   GDK_trademarkincircle               : constant Gdk_Key_Type := 16#0acb#;
   GDK_leftopentriangle                : constant Gdk_Key_Type := 16#0acc#;
   GDK_rightopentriangle               : constant Gdk_Key_Type := 16#0acd#;
   GDK_emopencircle                    : constant Gdk_Key_Type := 16#0ace#;
   GDK_emopenrectangle                 : constant Gdk_Key_Type := 16#0acf#;
   GDK_leftsinglequotemark             : constant Gdk_Key_Type := 16#0ad0#;
   GDK_rightsinglequotemark            : constant Gdk_Key_Type := 16#0ad1#;
   GDK_leftdoublequotemark             : constant Gdk_Key_Type := 16#0ad2#;
   GDK_rightdoublequotemark            : constant Gdk_Key_Type := 16#0ad3#;
   GDK_prescription                    : constant Gdk_Key_Type := 16#0ad4#;
   GDK_minutes                         : constant Gdk_Key_Type := 16#0ad6#;
   GDK_seconds                         : constant Gdk_Key_Type := 16#0ad7#;
   GDK_latincross                      : constant Gdk_Key_Type := 16#0ad9#;
   GDK_hexagram                        : constant Gdk_Key_Type := 16#0ada#;
   GDK_filledrectbullet                : constant Gdk_Key_Type := 16#0adb#;
   GDK_filledlefttribullet             : constant Gdk_Key_Type := 16#0adc#;
   GDK_filledrighttribullet            : constant Gdk_Key_Type := 16#0add#;
   GDK_emfilledcircle                  : constant Gdk_Key_Type := 16#0ade#;
   GDK_emfilledrect                    : constant Gdk_Key_Type := 16#0adf#;
   GDK_enopencircbullet                : constant Gdk_Key_Type := 16#0ae0#;
   GDK_enopensquarebullet              : constant Gdk_Key_Type := 16#0ae1#;
   GDK_openrectbullet                  : constant Gdk_Key_Type := 16#0ae2#;
   GDK_opentribulletup                 : constant Gdk_Key_Type := 16#0ae3#;
   GDK_opentribulletdown               : constant Gdk_Key_Type := 16#0ae4#;
   GDK_openstar                        : constant Gdk_Key_Type := 16#0ae5#;
   GDK_enfilledcircbullet              : constant Gdk_Key_Type := 16#0ae6#;
   GDK_enfilledsqbullet                : constant Gdk_Key_Type := 16#0ae7#;
   GDK_filledtribulletup               : constant Gdk_Key_Type := 16#0ae8#;
   GDK_filledtribulletdown             : constant Gdk_Key_Type := 16#0ae9#;
   GDK_leftpointer                     : constant Gdk_Key_Type := 16#0aea#;
   GDK_rightpointer                    : constant Gdk_Key_Type := 16#0aeb#;
   GDK_club                            : constant Gdk_Key_Type := 16#0aec#;
   GDK_diamond                         : constant Gdk_Key_Type := 16#0aed#;
   GDK_heart                           : constant Gdk_Key_Type := 16#0aee#;
   GDK_maltesecross                    : constant Gdk_Key_Type := 16#0af0#;
   GDK_dagger                          : constant Gdk_Key_Type := 16#0af1#;
   GDK_doubledagger                    : constant Gdk_Key_Type := 16#0af2#;
   GDK_checkmark                       : constant Gdk_Key_Type := 16#0af3#;
   GDK_ballotcross                     : constant Gdk_Key_Type := 16#0af4#;
   GDK_musicalsharp                    : constant Gdk_Key_Type := 16#0af5#;
   GDK_musicalflat                     : constant Gdk_Key_Type := 16#0af6#;
   GDK_malesymbol                      : constant Gdk_Key_Type := 16#0af7#;
   GDK_femalesymbol                    : constant Gdk_Key_Type := 16#0af8#;
   GDK_telephone                       : constant Gdk_Key_Type := 16#0af9#;
   GDK_telephonerecorder               : constant Gdk_Key_Type := 16#0afa#;
   GDK_phonographcopyright             : constant Gdk_Key_Type := 16#0afb#;
   GDK_caret                           : constant Gdk_Key_Type := 16#0afc#;
   GDK_singlelowquotemark              : constant Gdk_Key_Type := 16#0afd#;
   GDK_doublelowquotemark              : constant Gdk_Key_Type := 16#0afe#;
   GDK_cursor                          : constant Gdk_Key_Type := 16#0aff#;
   GDK_leftcaret                       : constant Gdk_Key_Type := 16#0ba3#;
   GDK_rightcaret                      : constant Gdk_Key_Type := 16#0ba6#;
   GDK_downcaret                       : constant Gdk_Key_Type := 16#0ba8#;
   GDK_upcaret                         : constant Gdk_Key_Type := 16#0ba9#;
   GDK_overbar                         : constant Gdk_Key_Type := 16#0bc0#;
   GDK_downtack                        : constant Gdk_Key_Type := 16#0bc2#;
   GDK_upshoe                          : constant Gdk_Key_Type := 16#0bc3#;
   GDK_downstile                       : constant Gdk_Key_Type := 16#0bc4#;
   GDK_underbar                        : constant Gdk_Key_Type := 16#0bc6#;
   GDK_jot                             : constant Gdk_Key_Type := 16#0bca#;
   GDK_quad                            : constant Gdk_Key_Type := 16#0bcc#;
   GDK_uptack                          : constant Gdk_Key_Type := 16#0bce#;
   GDK_circle                          : constant Gdk_Key_Type := 16#0bcf#;
   GDK_upstile                         : constant Gdk_Key_Type := 16#0bd3#;
   GDK_downshoe                        : constant Gdk_Key_Type := 16#0bd6#;
   GDK_rightshoe                       : constant Gdk_Key_Type := 16#0bd8#;
   GDK_leftshoe                        : constant Gdk_Key_Type := 16#0bda#;
   GDK_lefttack                        : constant Gdk_Key_Type := 16#0bdc#;
   GDK_righttack                       : constant Gdk_Key_Type := 16#0bfc#;
   GDK_hebrew_doublelowline            : constant Gdk_Key_Type := 16#0cdf#;
   GDK_hebrew_aleph                    : constant Gdk_Key_Type := 16#0ce0#;
   GDK_hebrew_bet                      : constant Gdk_Key_Type := 16#0ce1#;
   GDK_hebrew_beth                     : constant Gdk_Key_Type := 16#0ce1#;
   GDK_hebrew_gimel                    : constant Gdk_Key_Type := 16#0ce2#;
   GDK_hebrew_gimmel                   : constant Gdk_Key_Type := 16#0ce2#;
   GDK_hebrew_dalet                    : constant Gdk_Key_Type := 16#0ce3#;
   GDK_hebrew_daleth                   : constant Gdk_Key_Type := 16#0ce3#;
   GDK_hebrew_he                       : constant Gdk_Key_Type := 16#0ce4#;
   GDK_hebrew_waw                      : constant Gdk_Key_Type := 16#0ce5#;
   GDK_hebrew_zain                     : constant Gdk_Key_Type := 16#0ce6#;
   GDK_hebrew_zayin                    : constant Gdk_Key_Type := 16#0ce6#;
   GDK_hebrew_chet                     : constant Gdk_Key_Type := 16#0ce7#;
   GDK_hebrew_het                      : constant Gdk_Key_Type := 16#0ce7#;
   GDK_hebrew_tet                      : constant Gdk_Key_Type := 16#0ce8#;
   GDK_hebrew_teth                     : constant Gdk_Key_Type := 16#0ce8#;
   GDK_hebrew_yod                      : constant Gdk_Key_Type := 16#0ce9#;
   GDK_hebrew_finalkaph                : constant Gdk_Key_Type := 16#0cea#;
   GDK_hebrew_kaph                     : constant Gdk_Key_Type := 16#0ceb#;
   GDK_hebrew_lamed                    : constant Gdk_Key_Type := 16#0cec#;
   GDK_hebrew_finalmem                 : constant Gdk_Key_Type := 16#0ced#;
   GDK_hebrew_mem                      : constant Gdk_Key_Type := 16#0cee#;
   GDK_hebrew_finalnun                 : constant Gdk_Key_Type := 16#0cef#;
   GDK_hebrew_nun                      : constant Gdk_Key_Type := 16#0cf0#;
   GDK_hebrew_samech                   : constant Gdk_Key_Type := 16#0cf1#;
   GDK_hebrew_samekh                   : constant Gdk_Key_Type := 16#0cf1#;
   GDK_hebrew_ayin                     : constant Gdk_Key_Type := 16#0cf2#;
   GDK_hebrew_finalpe                  : constant Gdk_Key_Type := 16#0cf3#;
   GDK_hebrew_pe                       : constant Gdk_Key_Type := 16#0cf4#;
   GDK_hebrew_finalzade                : constant Gdk_Key_Type := 16#0cf5#;
   GDK_hebrew_finalzadi                : constant Gdk_Key_Type := 16#0cf5#;
   GDK_hebrew_zade                     : constant Gdk_Key_Type := 16#0cf6#;
   GDK_hebrew_zadi                     : constant Gdk_Key_Type := 16#0cf6#;
   GDK_hebrew_qoph                     : constant Gdk_Key_Type := 16#0cf7#;
   GDK_hebrew_kuf                      : constant Gdk_Key_Type := 16#0cf7#;
   GDK_hebrew_resh                     : constant Gdk_Key_Type := 16#0cf8#;
   GDK_hebrew_shin                     : constant Gdk_Key_Type := 16#0cf9#;
   GDK_hebrew_taw                      : constant Gdk_Key_Type := 16#0cfa#;
   GDK_hebrew_taf                      : constant Gdk_Key_Type := 16#0cfa#;
   GDK_Hebrew_switch                   : constant Gdk_Key_Type := 16#FF7E#;
   GDK_Thai_kokai                      : constant Gdk_Key_Type := 16#0da1#;
   GDK_Thai_khokhai                    : constant Gdk_Key_Type := 16#0da2#;
   GDK_Thai_khokhuat                   : constant Gdk_Key_Type := 16#0da3#;
   GDK_Thai_khokhwai                   : constant Gdk_Key_Type := 16#0da4#;
   GDK_Thai_khokhon                    : constant Gdk_Key_Type := 16#0da5#;
   GDK_Thai_khorakhang                 : constant Gdk_Key_Type := 16#0da6#;
   GDK_Thai_ngongu                     : constant Gdk_Key_Type := 16#0da7#;
   GDK_Thai_chochan                    : constant Gdk_Key_Type := 16#0da8#;
   GDK_Thai_choching                   : constant Gdk_Key_Type := 16#0da9#;
   GDK_Thai_chochang                   : constant Gdk_Key_Type := 16#0daa#;
   GDK_Thai_soso                       : constant Gdk_Key_Type := 16#0dab#;
   GDK_Thai_chochoe                    : constant Gdk_Key_Type := 16#0dac#;
   GDK_Thai_yoying                     : constant Gdk_Key_Type := 16#0dad#;
   GDK_Thai_dochada                    : constant Gdk_Key_Type := 16#0dae#;
   GDK_Thai_topatak                    : constant Gdk_Key_Type := 16#0daf#;
   GDK_Thai_thothan                    : constant Gdk_Key_Type := 16#0db0#;
   GDK_Thai_thonangmontho              : constant Gdk_Key_Type := 16#0db1#;
   GDK_Thai_thophuthao                 : constant Gdk_Key_Type := 16#0db2#;
   GDK_Thai_nonen                      : constant Gdk_Key_Type := 16#0db3#;
   GDK_Thai_dodek                      : constant Gdk_Key_Type := 16#0db4#;
   GDK_Thai_totao                      : constant Gdk_Key_Type := 16#0db5#;
   GDK_Thai_thothung                   : constant Gdk_Key_Type := 16#0db6#;
   GDK_Thai_thothahan                  : constant Gdk_Key_Type := 16#0db7#;
   GDK_Thai_thothong                   : constant Gdk_Key_Type := 16#0db8#;
   GDK_Thai_nonu                       : constant Gdk_Key_Type := 16#0db9#;
   GDK_Thai_bobaimai                   : constant Gdk_Key_Type := 16#0dba#;
   GDK_Thai_popla                      : constant Gdk_Key_Type := 16#0dbb#;
   GDK_Thai_phophung                   : constant Gdk_Key_Type := 16#0dbc#;
   GDK_Thai_fofa                       : constant Gdk_Key_Type := 16#0dbd#;
   GDK_Thai_phophan                    : constant Gdk_Key_Type := 16#0dbe#;
   GDK_Thai_fofan                      : constant Gdk_Key_Type := 16#0dbf#;
   GDK_Thai_phosamphao                 : constant Gdk_Key_Type := 16#0dc0#;
   GDK_Thai_moma                       : constant Gdk_Key_Type := 16#0dc1#;
   GDK_Thai_yoyak                      : constant Gdk_Key_Type := 16#0dc2#;
   GDK_Thai_rorua                      : constant Gdk_Key_Type := 16#0dc3#;
   GDK_Thai_ru                         : constant Gdk_Key_Type := 16#0dc4#;
   GDK_Thai_loling                     : constant Gdk_Key_Type := 16#0dc5#;
   GDK_Thai_lu                         : constant Gdk_Key_Type := 16#0dc6#;
   GDK_Thai_wowaen                     : constant Gdk_Key_Type := 16#0dc7#;
   GDK_Thai_sosala                     : constant Gdk_Key_Type := 16#0dc8#;
   GDK_Thai_sorusi                     : constant Gdk_Key_Type := 16#0dc9#;
   GDK_Thai_sosua                      : constant Gdk_Key_Type := 16#0dca#;
   GDK_Thai_hohip                      : constant Gdk_Key_Type := 16#0dcb#;
   GDK_Thai_lochula                    : constant Gdk_Key_Type := 16#0dcc#;
   GDK_Thai_oang                       : constant Gdk_Key_Type := 16#0dcd#;
   GDK_Thai_honokhuk                   : constant Gdk_Key_Type := 16#0dce#;
   GDK_Thai_paiyannoi                  : constant Gdk_Key_Type := 16#0dcf#;
   GDK_Thai_saraa                      : constant Gdk_Key_Type := 16#0dd0#;
   GDK_Thai_maihanakat                 : constant Gdk_Key_Type := 16#0dd1#;
   GDK_Thai_saraaa                     : constant Gdk_Key_Type := 16#0dd2#;
   GDK_Thai_saraam                     : constant Gdk_Key_Type := 16#0dd3#;
   GDK_Thai_sarai                      : constant Gdk_Key_Type := 16#0dd4#;
   GDK_Thai_saraii                     : constant Gdk_Key_Type := 16#0dd5#;
   GDK_Thai_saraue                     : constant Gdk_Key_Type := 16#0dd6#;
   GDK_Thai_sarauee                    : constant Gdk_Key_Type := 16#0dd7#;
   GDK_Thai_sarau                      : constant Gdk_Key_Type := 16#0dd8#;
   GDK_Thai_sarauu                     : constant Gdk_Key_Type := 16#0dd9#;
   GDK_Thai_phinthu                    : constant Gdk_Key_Type := 16#0dda#;
   GDK_Thai_Maihanakat_Maitho          : constant Gdk_Key_Type := 16#0dde#;
   GDK_Thai_baht                       : constant Gdk_Key_Type := 16#0ddf#;
   GDK_Thai_sarae                      : constant Gdk_Key_Type := 16#0de0#;
   GDK_Thai_saraae                     : constant Gdk_Key_Type := 16#0de1#;
   GDK_Thai_sarao                      : constant Gdk_Key_Type := 16#0de2#;
   GDK_Thai_saraaimaimuan              : constant Gdk_Key_Type := 16#0de3#;
   GDK_Thai_saraaimaimalai             : constant Gdk_Key_Type := 16#0de4#;
   GDK_Thai_lakkhangyao                : constant Gdk_Key_Type := 16#0de5#;
   GDK_Thai_maiyamok                   : constant Gdk_Key_Type := 16#0de6#;
   GDK_Thai_maitaikhu                  : constant Gdk_Key_Type := 16#0de7#;
   GDK_Thai_maiek                      : constant Gdk_Key_Type := 16#0de8#;
   GDK_Thai_maitho                     : constant Gdk_Key_Type := 16#0de9#;
   GDK_Thai_maitri                     : constant Gdk_Key_Type := 16#0dea#;
   GDK_Thai_maichattawa                : constant Gdk_Key_Type := 16#0deb#;
   GDK_Thai_thanthakhat                : constant Gdk_Key_Type := 16#0dec#;
   GDK_Thai_nikhahit                   : constant Gdk_Key_Type := 16#0ded#;
   GDK_Thai_leksun                     : constant Gdk_Key_Type := 16#0df0#;
   GDK_Thai_leknung                    : constant Gdk_Key_Type := 16#0df1#;
   GDK_Thai_leksong                    : constant Gdk_Key_Type := 16#0df2#;
   GDK_Thai_leksam                     : constant Gdk_Key_Type := 16#0df3#;
   GDK_Thai_leksi                      : constant Gdk_Key_Type := 16#0df4#;
   GDK_Thai_lekha                      : constant Gdk_Key_Type := 16#0df5#;
   GDK_Thai_lekhok                     : constant Gdk_Key_Type := 16#0df6#;
   GDK_Thai_lekchet                    : constant Gdk_Key_Type := 16#0df7#;
   GDK_Thai_lekpaet                    : constant Gdk_Key_Type := 16#0df8#;
   GDK_Thai_lekkao                     : constant Gdk_Key_Type := 16#0df9#;
   GDK_Hangul                          : constant Gdk_Key_Type := 16#ff31#;
   GDK_Hangul_Start                    : constant Gdk_Key_Type := 16#ff32#;
   GDK_Hangul_End                      : constant Gdk_Key_Type := 16#ff33#;
   GDK_Hangul_Hanja                    : constant Gdk_Key_Type := 16#ff34#;
   GDK_Hangul_Jamo                     : constant Gdk_Key_Type := 16#ff35#;
   GDK_Hangul_Romaja                   : constant Gdk_Key_Type := 16#ff36#;
   GDK_Hangul_Codeinput                : constant Gdk_Key_Type := 16#ff37#;
   GDK_Hangul_Jeonja                   : constant Gdk_Key_Type := 16#ff38#;
   GDK_Hangul_Banja                    : constant Gdk_Key_Type := 16#ff39#;
   GDK_Hangul_PreHanja                 : constant Gdk_Key_Type := 16#ff3a#;
   GDK_Hangul_PostHanja                : constant Gdk_Key_Type := 16#ff3b#;
   GDK_Hangul_SingleCandidate          : constant Gdk_Key_Type := 16#ff3c#;
   GDK_Hangul_MultipleCandidate        : constant Gdk_Key_Type := 16#ff3d#;
   GDK_Hangul_PreviousCandidate        : constant Gdk_Key_Type := 16#ff3e#;
   GDK_Hangul_Special                  : constant Gdk_Key_Type := 16#ff3f#;
   GDK_Hangul_switch                   : constant Gdk_Key_Type := 16#FF7E#;
   GDK_Hangul_Kiyeog                   : constant Gdk_Key_Type := 16#0ea1#;
   GDK_Hangul_SsangKiyeog              : constant Gdk_Key_Type := 16#0ea2#;
   GDK_Hangul_KiyeogSios               : constant Gdk_Key_Type := 16#0ea3#;
   GDK_Hangul_Nieun                    : constant Gdk_Key_Type := 16#0ea4#;
   GDK_Hangul_NieunJieuj               : constant Gdk_Key_Type := 16#0ea5#;
   GDK_Hangul_NieunHieuh               : constant Gdk_Key_Type := 16#0ea6#;
   GDK_Hangul_Dikeud                   : constant Gdk_Key_Type := 16#0ea7#;
   GDK_Hangul_SsangDikeud              : constant Gdk_Key_Type := 16#0ea8#;
   GDK_Hangul_Rieul                    : constant Gdk_Key_Type := 16#0ea9#;
   GDK_Hangul_RieulKiyeog              : constant Gdk_Key_Type := 16#0eaa#;
   GDK_Hangul_RieulMieum               : constant Gdk_Key_Type := 16#0eab#;
   GDK_Hangul_RieulPieub               : constant Gdk_Key_Type := 16#0eac#;
   GDK_Hangul_RieulSios                : constant Gdk_Key_Type := 16#0ead#;
   GDK_Hangul_RieulTieut               : constant Gdk_Key_Type := 16#0eae#;
   GDK_Hangul_RieulPhieuf              : constant Gdk_Key_Type := 16#0eaf#;
   GDK_Hangul_RieulHieuh               : constant Gdk_Key_Type := 16#0eb0#;
   GDK_Hangul_Mieum                    : constant Gdk_Key_Type := 16#0eb1#;
   GDK_Hangul_Pieub                    : constant Gdk_Key_Type := 16#0eb2#;
   GDK_Hangul_SsangPieub               : constant Gdk_Key_Type := 16#0eb3#;
   GDK_Hangul_PieubSios                : constant Gdk_Key_Type := 16#0eb4#;
   GDK_Hangul_Sios                     : constant Gdk_Key_Type := 16#0eb5#;
   GDK_Hangul_SsangSios                : constant Gdk_Key_Type := 16#0eb6#;
   GDK_Hangul_Ieung                    : constant Gdk_Key_Type := 16#0eb7#;
   GDK_Hangul_Jieuj                    : constant Gdk_Key_Type := 16#0eb8#;
   GDK_Hangul_SsangJieuj               : constant Gdk_Key_Type := 16#0eb9#;
   GDK_Hangul_Cieuc                    : constant Gdk_Key_Type := 16#0eba#;
   GDK_Hangul_Khieuq                   : constant Gdk_Key_Type := 16#0ebb#;
   GDK_Hangul_Tieut                    : constant Gdk_Key_Type := 16#0ebc#;
   GDK_Hangul_Phieuf                   : constant Gdk_Key_Type := 16#0ebd#;
   GDK_Hangul_Hieuh                    : constant Gdk_Key_Type := 16#0ebe#;
   GDK_Hangul_A                        : constant Gdk_Key_Type := 16#0ebf#;
   GDK_Hangul_AE                       : constant Gdk_Key_Type := 16#0ec0#;
   GDK_Hangul_YA                       : constant Gdk_Key_Type := 16#0ec1#;
   GDK_Hangul_YAE                      : constant Gdk_Key_Type := 16#0ec2#;
   GDK_Hangul_EO                       : constant Gdk_Key_Type := 16#0ec3#;
   GDK_Hangul_E                        : constant Gdk_Key_Type := 16#0ec4#;
   GDK_Hangul_YEO                      : constant Gdk_Key_Type := 16#0ec5#;
   GDK_Hangul_YE                       : constant Gdk_Key_Type := 16#0ec6#;
   GDK_Hangul_O                        : constant Gdk_Key_Type := 16#0ec7#;
   GDK_Hangul_WA                       : constant Gdk_Key_Type := 16#0ec8#;
   GDK_Hangul_WAE                      : constant Gdk_Key_Type := 16#0ec9#;
   GDK_Hangul_OE                       : constant Gdk_Key_Type := 16#0eca#;
   GDK_Hangul_YO                       : constant Gdk_Key_Type := 16#0ecb#;
   GDK_Hangul_U                        : constant Gdk_Key_Type := 16#0ecc#;
   GDK_Hangul_WEO                      : constant Gdk_Key_Type := 16#0ecd#;
   GDK_Hangul_WE                       : constant Gdk_Key_Type := 16#0ece#;
   GDK_Hangul_WI                       : constant Gdk_Key_Type := 16#0ecf#;
   GDK_Hangul_YU                       : constant Gdk_Key_Type := 16#0ed0#;
   GDK_Hangul_EU                       : constant Gdk_Key_Type := 16#0ed1#;
   GDK_Hangul_YI                       : constant Gdk_Key_Type := 16#0ed2#;
   GDK_Hangul_I                        : constant Gdk_Key_Type := 16#0ed3#;
   GDK_Hangul_J_Kiyeog                 : constant Gdk_Key_Type := 16#0ed4#;
   GDK_Hangul_J_SsangKiyeog            : constant Gdk_Key_Type := 16#0ed5#;
   GDK_Hangul_J_KiyeogSios             : constant Gdk_Key_Type := 16#0ed6#;
   GDK_Hangul_J_Nieun                  : constant Gdk_Key_Type := 16#0ed7#;
   GDK_Hangul_J_NieunJieuj             : constant Gdk_Key_Type := 16#0ed8#;
   GDK_Hangul_J_NieunHieuh             : constant Gdk_Key_Type := 16#0ed9#;
   GDK_Hangul_J_Dikeud                 : constant Gdk_Key_Type := 16#0eda#;
   GDK_Hangul_J_Rieul                  : constant Gdk_Key_Type := 16#0edb#;
   GDK_Hangul_J_RieulKiyeog            : constant Gdk_Key_Type := 16#0edc#;
   GDK_Hangul_J_RieulMieum             : constant Gdk_Key_Type := 16#0edd#;
   GDK_Hangul_J_RieulPieub             : constant Gdk_Key_Type := 16#0ede#;
   GDK_Hangul_J_RieulSios              : constant Gdk_Key_Type := 16#0edf#;
   GDK_Hangul_J_RieulTieut             : constant Gdk_Key_Type := 16#0ee0#;
   GDK_Hangul_J_RieulPhieuf            : constant Gdk_Key_Type := 16#0ee1#;
   GDK_Hangul_J_RieulHieuh             : constant Gdk_Key_Type := 16#0ee2#;
   GDK_Hangul_J_Mieum                  : constant Gdk_Key_Type := 16#0ee3#;
   GDK_Hangul_J_Pieub                  : constant Gdk_Key_Type := 16#0ee4#;
   GDK_Hangul_J_PieubSios              : constant Gdk_Key_Type := 16#0ee5#;
   GDK_Hangul_J_Sios                   : constant Gdk_Key_Type := 16#0ee6#;
   GDK_Hangul_J_SsangSios              : constant Gdk_Key_Type := 16#0ee7#;
   GDK_Hangul_J_Ieung                  : constant Gdk_Key_Type := 16#0ee8#;
   GDK_Hangul_J_Jieuj                  : constant Gdk_Key_Type := 16#0ee9#;
   GDK_Hangul_J_Cieuc                  : constant Gdk_Key_Type := 16#0eea#;
   GDK_Hangul_J_Khieuq                 : constant Gdk_Key_Type := 16#0eeb#;
   GDK_Hangul_J_Tieut                  : constant Gdk_Key_Type := 16#0eec#;
   GDK_Hangul_J_Phieuf                 : constant Gdk_Key_Type := 16#0eed#;
   GDK_Hangul_J_Hieuh                  : constant Gdk_Key_Type := 16#0eee#;
   GDK_Hangul_RieulYeorinHieuh         : constant Gdk_Key_Type := 16#0eef#;
   GDK_Hangul_SunkyeongeumMieum        : constant Gdk_Key_Type := 16#0ef0#;
   GDK_Hangul_SunkyeongeumPieub        : constant Gdk_Key_Type := 16#0ef1#;
   GDK_Hangul_PanSios                  : constant Gdk_Key_Type := 16#0ef2#;
   GDK_Hangul_KkogjiDalrinIeung        : constant Gdk_Key_Type := 16#0ef3#;
   GDK_Hangul_SunkyeongeumPhieuf       : constant Gdk_Key_Type := 16#0ef4#;
   GDK_Hangul_YeorinHieuh              : constant Gdk_Key_Type := 16#0ef5#;
   GDK_Hangul_AraeA                    : constant Gdk_Key_Type := 16#0ef6#;
   GDK_Hangul_AraeAE                   : constant Gdk_Key_Type := 16#0ef7#;
   GDK_Hangul_J_PanSios                : constant Gdk_Key_Type := 16#0ef8#;
   GDK_Hangul_J_KkogjiDalrinIeung      : constant Gdk_Key_Type := 16#0ef9#;
   GDK_Hangul_J_YeorinHieuh            : constant Gdk_Key_Type := 16#0efa#;
   GDK_Korean_Won                      : constant Gdk_Key_Type := 16#0eff#;

end Gdk.Types.Keysyms;
